/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.pfam.PfamScanAnnotations;
import org.sing_group.seda.pfam.PfamScanRequestConfiguration;
import org.sing_group.seda.pfam.PfamScanResultsParser;
import org.sing_group.seda.pfam.PfamScanStatus;

public class PfamScanRequest {
    private static final String URL_RUN = "https://www.ebi.ac.uk/Tools/services/rest/pfamscan/run";
    private static final String URL_STATUS = "https://www.ebi.ac.uk/Tools/services/rest/pfamscan/status/";
    private static final String URL_RESULT = "https://www.ebi.ac.uk/Tools/services/rest/pfamscan/result/%s/out";
    private Sequence sequence;
    private PfamScanRequestConfiguration configuration;
    private String requestId = null;
    private PfamScanStatus status = null;
    private PfamScanAnnotations annotations = null;

    public PfamScanRequest(String requestId) {
        this.requestId = requestId;
    }

    public PfamScanRequest(Sequence sequence, PfamScanRequestConfiguration configuration) {
        this.sequence = sequence;
        this.configuration = configuration;
    }

    public Optional<String> getRequestId() {
        return Optional.ofNullable(this.requestId);
    }

    public void query() throws ClientProtocolException, IOException {
        if (this.requestId != null) {
            throw new RuntimeException("A query has already been done with request ID = " + this.requestId);
        }
        HttpPost httpPost = new HttpPost(URL_RUN);
        httpPost.setEntity(this.buildMultipartEntity());
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            httpClient.close();
            throw new IOException("Query failed: " + response.getStatusLine().getReasonPhrase());
        }
        this.requestId = EntityUtils.toString((HttpEntity)response.getEntity());
        httpClient.close();
    }

    private HttpEntity buildMultipartEntity() {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addTextBody("database", "pfam-a").addTextBody("asp", this.configuration.isActiveSitePrediction() ? "true" : "false").addTextBody("format", "txt").addTextBody("email", this.configuration.getEmail()).addTextBody("title", this.sequence.getName()).addTextBody("sequence", this.sequence.getChain());
        if (this.configuration.getEvalue().isPresent()) {
            entityBuilder = entityBuilder.addTextBody("evalue", Double.toString(this.configuration.getEvalue().get()));
        }
        return entityBuilder.build();
    }

    public PfamScanStatus getStatus() throws ClientProtocolException, IOException {
        if (this.requestId == null) {
            return PfamScanStatus.UNSUBMITED;
        }
        if (this.status == null || this.status.isAlive()) {
            HttpGet httpGet = new HttpGet(URL_STATUS + this.requestId);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            httpClient.close();
            if (status == 200) {
                this.status = PfamScanStatus.valueOf(responseString);
            } else {
                throw new IOException(status + ": " + reasonPhrase);
            }
        }
        return this.status;
    }

    public PfamScanAnnotations getResult() throws ClientProtocolException, IOException {
        if (this.annotations != null) {
            return this.annotations;
        }
        if (this.requestId == null) {
            throw new RuntimeException("The query has not been submited yet");
        }
        if (this.status.equals((Object)PfamScanStatus.FINISHED)) {
            HttpGet httpGet = new HttpGet(String.format(URL_RESULT, this.requestId));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                Path outputFile = Files.createTempFile("seda-pfam-scan-results", ".out", new FileAttribute[0]);
                response.getEntity().writeTo((OutputStream)new FileOutputStream(outputFile.toFile()));
                httpClient.close();
                this.annotations = PfamScanResultsParser.parse(outputFile);
                return this.annotations;
            }
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            httpClient.close();
            throw new IOException(status + ": " + reasonPhrase);
        }
        throw new IllegalStateException("The query status must be FINISHED. Current status: " + (Object)((Object)this.status));
    }
}

