/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.core;

import java.util.Arrays;
import java.util.Collections;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.transformation.dataset.UniProtBlastTransformation;
import org.sing_group.seda.plugin.core.Group;
import org.sing_group.seda.plugin.core.info.AbstractInfo;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;

public class UniProtBlastSedaPluginInfo
extends AbstractInfo {
    public static final String NAME = "UniProt BLAST";
    public static final String SHORT_NAME = "blast-uniprot";
    public static final String DESCRIPTION = "Perform a BLAST query through the UniProt web server (https://www.uniprot.org/blast/).";
    public static final String GROUP = Group.GROUP_BLAST.getName();
    public static final String PARAM_DATABASE_NAME = "database";
    public static final String PARAM_DATABASE_SHORT_NAME = "db";
    public static final String PARAM_DATABASE_DESCRIPTION = "Database";
    public static final String PARAM_DATABASE_HELP = UniProtBlastSedaPluginInfo.shortEnumString("The target database.", DatabaseOption.class);
    public static final String PARAM_DATABASE_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml(PARAM_DATABASE_HELP);
    public static final String PARAM_OUTPUT_TYPE_NAME = "output-type";
    public static final String PARAM_OUTPUT_TYPE_SHORT_NAME = "ot";
    public static final String PARAM_OUTPUT_TYPE_DESCRIPTION = "Output type";
    private static final String[] PARAM_OUTPUT_TYPE_HELP_ENUM = new String[]{"Creates a FASTA file with the complete sequences of each sequence that has an alignment against the query sequence.", "Creates a FASTA file with the portions of the sequences aligned against the query."};
    public static final String PARAM_OUTPUT_TYPE_HELP = UniProtBlastSedaPluginInfo.longEnumStringForCli("The output type.", UniProtBlastSedaPluginInfo.cliMap((Enum[])OutputTypeParameter.values(), (String[])PARAM_OUTPUT_TYPE_HELP_ENUM));
    public static final String PARAM_OUTPUT_TYPE_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml(UniProtBlastSedaPluginInfo.longEnumStringForGui("The output type.", UniProtBlastSedaPluginInfo.guiMap((Enum[])OutputTypeParameter.values(), (String[])PARAM_OUTPUT_TYPE_HELP_ENUM)));
    public static final String PARAM_EXPECTATION_VALUE_NAME = "expectation-value";
    public static final String PARAM_EXPECTATION_VALUE_SHORT_NAME = "e";
    public static final String PARAM_EXPECTATION_VALUE_DESCRIPTION = "E-Threshold";
    public static final String PARAM_EXPECTATION_VALUE_HELP_BASE = "The expectation value (E) threshold is a statistical measure of the number of expected matches in a random database. The lower the e-value, the more likely the match is to be significant.E-values between 0.1 and 10 are generally dubious, and over 10 are unlikely to have biological significance. In all cases, those matches need to be verified manually. You may need to increase the E threshold if you have a very short query sequence, to detect very weak similarities, or similarities in a short region, or if your sequence has a low complexity region and you use the filter option.";
    public static final String PARAM_EXPECTATION_VALUE_HELP = UniProtBlastSedaPluginInfo.shortEnumString("The expectation value (E) threshold is a statistical measure of the number of expected matches in a random database. The lower the e-value, the more likely the match is to be significant.E-values between 0.1 and 10 are generally dubious, and over 10 are unlikely to have biological significance. In all cases, those matches need to be verified manually. You may need to increase the E threshold if you have a very short query sequence, to detect very weak similarities, or similarities in a short region, or if your sequence has a low complexity region and you use the filter option.", ExpectationOption.class);
    public static final String PARAM_EXPECTATION_VALUE_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml("The expectation value (E) threshold is a statistical measure of the number of expected matches in a random database. The lower the e-value, the more likely the match is to be significant.E-values between 0.1 and 10 are generally dubious, and over 10 are unlikely to have biological significance. In all cases, those matches need to be verified manually. You may need to increase the E threshold if you have a very short query sequence, to detect very weak similarities, or similarities in a short region, or if your sequence has a low complexity region and you use the filter option.", Collections.emptyList(), Arrays.asList("filter"), true);
    public static final String PARAM_MATRIX_OPTION_NAME = "matrix";
    public static final String PARAM_MATRIX_OPTION_SHORT_NAME = "m";
    public static final String PARAM_MATRIX_OPTION_DESCRIPTION = "Matrix";
    public static final String PARAM_MATRIX_OPTION_HELP_BASE = "The scoring matrix to use. The matrix assigns a probability score for each position in an alignment. The BLOSUM matrix assigns a probability score for each position in an alignment that is based on the frequency with which that substitution is known to occur among consensus blocks within related proteins. BLOSUM62 is among the best of the available matrices for detecting weak protein similarities. The PAM set of matrices is also available.";
    public static final String PARAM_MATRIX_OPTION_HELP = UniProtBlastSedaPluginInfo.shortEnumString("The scoring matrix to use. The matrix assigns a probability score for each position in an alignment. The BLOSUM matrix assigns a probability score for each position in an alignment that is based on the frequency with which that substitution is known to occur among consensus blocks within related proteins. BLOSUM62 is among the best of the available matrices for detecting weak protein similarities. The PAM set of matrices is also available.", MatrixOption.class);
    public static final String PARAM_MATRIX_OPTION_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml("The scoring matrix to use. The matrix assigns a probability score for each position in an alignment. The BLOSUM matrix assigns a probability score for each position in an alignment that is based on the frequency with which that substitution is known to occur among consensus blocks within related proteins. BLOSUM62 is among the best of the available matrices for detecting weak protein similarities. The PAM set of matrices is also available.");
    public static final String PARAM_FILTER_NAME = "filter";
    public static final String PARAM_FILTER_SHORT_NAME = "f";
    public static final String PARAM_FILTER_DESCRIPTION = "Filtering";
    public static final String PARAM_FILTER_HELP_BASE = "Low-complexity regions (for example: stretches of cysteine in Q03751, or hydrophobic regions in membrane proteins) tend to produce spurious, insignificant matches with sequences in the database which have the same kind of low-complexity regions, but are unrelated biologically. If filtering low complexity regions is selected, the query sequence will be run through the program SEG, and all amino acids in low-complexity regions will be replaced by X's.";
    public static final String PARAM_FILTER_HELP = UniProtBlastSedaPluginInfo.shortEnumString("Low-complexity regions (for example: stretches of cysteine in Q03751, or hydrophobic regions in membrane proteins) tend to produce spurious, insignificant matches with sequences in the database which have the same kind of low-complexity regions, but are unrelated biologically. If filtering low complexity regions is selected, the query sequence will be run through the program SEG, and all amino acids in low-complexity regions will be replaced by X's.", FilterOption.class);
    public static final String PARAM_FILTER_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml("Low-complexity regions (for example: stretches of cysteine in Q03751, or hydrophobic regions in membrane proteins) tend to produce spurious, insignificant matches with sequences in the database which have the same kind of low-complexity regions, but are unrelated biologically. If filtering low complexity regions is selected, the query sequence will be run through the program SEG, and all amino acids in low-complexity regions will be replaced by X's.", Collections.emptyList(), Arrays.asList("filtering low complexity regions"), true);
    public static final String PARAM_GAPPED_NAME = "gapped";
    public static final String PARAM_GAPPED_SHORT_NAME = "g";
    public static final String PARAM_GAPPED_DESCRIPTION = "Gapped";
    public static final String PARAM_GAPPED_HELP = "Whether the query is gapped or not. This will allow gaps to be introduced in the sequences when the comparison is done.";
    public static final String PARAM_GAPPED_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml("Whether the query is gapped or not. This will allow gaps to be introduced in the sequences when the comparison is done.");
    public static final String PARAM_HITS_NAME = "hits";
    public static final String PARAM_HITS_SHORT_NAME = "h";
    public static final String PARAM_HITS_DESCRIPTION = "Hits";
    public static final String PARAM_HITS_HELP_BASE = "Limits the number of returned alignments.";
    public static final String PARAM_HITS_HELP = UniProtBlastSedaPluginInfo.shortEnumString("Limits the number of returned alignments.", AlignmentCutoffOption.class);
    public static final String PARAM_HITS_HELP_GUI = UniProtBlastSedaPluginInfo.toHtml("Limits the number of returned alignments.");
    public static final DatabaseOption DEFAULT_DATABASE_OPTION = UniProtBlastTransformation.DEFAULT_DATABASE;
    public static final OutputTypeParameter DEFAULT_OUTPUT_TYPE = UniProtBlastTransformation.DEFAULT_OUTPUT_TYPE_PARAMETER;
    public static final ExpectationOption DEFAULT_EXPECTATION_OPTION = UniProtBlastTransformation.DEFAULT_EXPECTATION_OPTION;
    public static final MatrixOption DEFAULT_MATRIX_OPTION = UniProtBlastTransformation.DEFAULT_MATRIX_OPTION;
    public static final FilterOption DEFAULT_FILTER_OPTION = UniProtBlastTransformation.DEFAULT_FILTER_OPTION;
    public static final AlignmentCutoffOption DEFAULT_ALIGNMENT_CUTOFF = UniProtBlastTransformation.DEFAULT_ALIGNMENT_CUTOFF;
}

