/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParameterSeparator;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.DoubleTextField;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.ColorUtils;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.parameters.FilterParameter;
import org.sing_group.seda.blast.ncbi.parameters.MatrixParameter;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.plugin.core.NcbiBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.ncbi.NcbiBlastTransformationProvider;

public class NcbiBlastTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    private RadioButtonsPanel<OutputTypeParameter> outputTypeParameter;
    private NcbiBlastTransformationProvider transformationProvider;
    private JComboBox<NcbiBlastType> blastTypeCombobox;
    private JComboBox<NcbiBlastDatabase> blastDatabaseCombobox;
    private JComboBox<MatrixParameter> matrixCombobox;
    private JLabel blastDatabaseWarning;
    private JCheckBox useFilter;
    private JCheckBox lookupMask;
    private DoubleTextField expectValue;
    private JIntegerTextField hitListSize;
    private JIntegerTextField wordSize;
    private JIntegerTextField threshold;

    public NcbiBlastTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new NcbiBlastTransformationProvider(this.getBlastType(), this.getBlastDatabase(), this.getOutputType());
        this.checkBlastDatabase();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        LinkedList<Object> dbParameters = new LinkedList<Object>();
        dbParameters.add(this.getBlastTypeParameter());
        dbParameters.add(this.getBlastDatabaseParameter());
        dbParameters.add(this.getOutputTypeParameter());
        dbParameters.add(new InputParameterSeparator("Optional parameters:", 25));
        dbParameters.add(this.getMatrixParameter());
        dbParameters.add(this.getFilterParameter());
        dbParameters.add(this.getExpectValueParameter());
        dbParameters.add(this.getHitListSizeParameter());
        dbParameters.add(this.getWordSizeParameter());
        dbParameters.add(this.getThresholdParameter());
        return dbParameters.toArray(new InputParameter[dbParameters.size()]);
    }

    private InputParameter getOutputTypeParameter() {
        this.outputTypeParameter = new RadioButtonsPanel((Object[])OutputTypeParameter.values(), 1, 2);
        this.outputTypeParameter.setSelectedItem((Object)OutputTypeParameter.ALIGNED);
        this.outputTypeParameter.addItemListener(this::outputTypeChanged);
        return new InputParameter("Output type: ", this.outputTypeParameter, NcbiBlastSedaPluginInfo.PARAM_OUTPUT_TYPE_HELP_GUI);
    }

    private void outputTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setOutputType(this.getOutputType()));
        }
    }

    private OutputTypeParameter getOutputType() {
        return (OutputTypeParameter)((Object)this.outputTypeParameter.getSelectedItem().get());
    }

    private InputParameter getBlastTypeParameter() {
        this.blastTypeCombobox = new JComboBox<NcbiBlastType>(NcbiBlastType.values());
        this.blastTypeCombobox.addItemListener(this::blastTypeChanged);
        return new InputParameter("BLAST type: ", this.blastTypeCombobox, "The BLAST program to execute.");
    }

    private void blastTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.checkBlastDatabase();
            SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastType(this.getBlastType()));
        }
    }

    private NcbiBlastType getBlastType() {
        return (NcbiBlastType)((Object)this.blastTypeCombobox.getSelectedItem());
    }

    private InputParameter getBlastDatabaseParameter() {
        this.blastDatabaseCombobox = new JComboBox<NcbiBlastDatabase>(NcbiBlastDatabase.values());
        this.blastDatabaseCombobox.addItemListener(this::blastDatabaseChanged);
        this.blastDatabaseCombobox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.blastDatabaseWarning = new JLabel(Icons.ICON_WARNING_COLOR_24);
        JPanel input = new JPanel();
        input.setLayout(new BoxLayout(input, 0));
        input.add(this.blastDatabaseCombobox);
        input.add(this.blastDatabaseWarning);
        this.blastDatabaseWarning.setVisible(false);
        return new InputParameter("BLAST database: ", (JComponent)input, "The NCBI database to run BLAST against.");
    }

    private void blastDatabaseChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.checkBlastDatabase();
            SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastDatabase(this.getBlastDatabase()));
        }
    }

    private NcbiBlastDatabase getBlastDatabase() {
        return (NcbiBlastDatabase)((Object)this.blastDatabaseCombobox.getSelectedItem());
    }

    private void checkBlastDatabase() {
        NcbiBlastType blastType = this.getBlastType();
        this.threshold.setEnabled(!blastType.equals((Object)NcbiBlastType.BLASTN) && !blastType.equals((Object)NcbiBlastType.MEGABLAST));
        boolean warningVisible = !this.getBlastType().getDatabaseType().equals((Object)this.getBlastDatabase().getSequenceType());
        this.blastDatabaseWarning.setVisible(warningVisible);
        StringBuilder tooltip = new StringBuilder("The selected blast program requires a ");
        tooltip.append(this.getBlastDatabase().getSequenceType().toString().toLowerCase()).append(" database and the selected one is a ").append(this.getBlastType().getDatabaseType().toString().toLowerCase()).append(" database.");
        this.blastDatabaseWarning.setToolTipText(warningVisible ? tooltip.toString() : null);
    }

    private InputParameter getMatrixParameter() {
        this.matrixCombobox = new JComboBox<MatrixParameter>(MatrixParameter.values());
        this.matrixCombobox.setSelectedItem(null);
        this.matrixCombobox.addItemListener(this::matrixParameterChanged);
        return new InputParameter("Matrix: ", this.matrixCombobox, "The scoring matrix to use.");
    }

    private void matrixParameterChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setMatrix(this.getMatrix()));
        }
    }

    private MatrixParameter getMatrix() {
        return (MatrixParameter)this.matrixCombobox.getSelectedItem();
    }

    private InputParameter getFilterParameter() {
        this.useFilter = new JCheckBox("Apply", false);
        this.lookupMask = new JCheckBox("Mask at lookup.", false);
        this.useFilter.addItemListener(this::filterChanged);
        this.lookupMask.addItemListener(this::filterChanged);
        JPanel input = new JPanel();
        input.setLayout(new GridLayout(1, 2));
        input.add(this.useFilter);
        input.add(this.lookupMask);
        return new InputParameter("Filter: ", (JComponent)input, "Low complexity filtering.");
    }

    private void filterChanged(ItemEvent event) {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setFilter(this.getFilter()));
    }

    private FilterParameter getFilter() {
        if (this.useFilter.isSelected()) {
            return new FilterParameter(true, this.lookupMask.isSelected());
        }
        return new FilterParameter(false);
    }

    private InputParameter getExpectValueParameter() {
        this.expectValue = new DoubleTextField();
        this.expectValue.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::expectValueChanged));
        return new InputParameter("Expectation value:", (JComponent)this.expectValue, "The expectation value (E) threshold for saving hits.");
    }

    private void expectValueChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.expectValue.getText().isEmpty()) {
                this.expectValue.setBackground(COLOR_VALID_INPUT);
                this.transformationProvider.clearExpectValue();
            } else {
                try {
                    Double eValue = this.getExpectValue();
                    this.transformationProvider.setExpectValue(eValue);
                    this.expectValue.setBackground(eValue > 0.0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setExpectValue(-1.0);
                    this.expectValue.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Double getExpectValue() {
        return Double.parseDouble(this.expectValue.getText());
    }

    private InputParameter getHitListSizeParameter() {
        this.hitListSize = new JIntegerTextField();
        this.hitListSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::hitListSizeValueChanged));
        return new InputParameter("Hit list size:", (JComponent)this.hitListSize, "Number of databases sequences to keep.");
    }

    private void hitListSizeValueChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.hitListSize.getText().isEmpty()) {
                this.hitListSize.setBackground(COLOR_VALID_INPUT);
                this.transformationProvider.clearHitListSize();
            } else {
                try {
                    Integer hitListSize = this.getHitListSizeValue();
                    this.transformationProvider.setHitListSizeValue(hitListSize);
                    this.hitListSize.setBackground(hitListSize > 0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setHitListSizeValue(-1);
                    this.hitListSize.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Integer getHitListSizeValue() {
        return Integer.parseInt(this.hitListSize.getText());
    }

    private InputParameter getWordSizeParameter() {
        this.wordSize = new JIntegerTextField();
        this.wordSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::wordSizeValueChanged));
        return new InputParameter("Word size:", (JComponent)this.wordSize, "Size of word for initial matches.");
    }

    private void wordSizeValueChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.wordSize.getText().isEmpty()) {
                this.wordSize.setBackground(COLOR_VALID_INPUT);
                this.transformationProvider.clearWordSize();
            } else {
                try {
                    Integer wordSize = this.getWordSizeValue();
                    this.transformationProvider.setWordSizeValue(wordSize);
                    this.wordSize.setBackground(wordSize > 0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setWordSizeValue(-1);
                    this.wordSize.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Integer getWordSizeValue() {
        return Integer.parseInt(this.wordSize.getText());
    }

    private InputParameter getThresholdParameter() {
        this.threshold = new JIntegerTextField();
        this.threshold.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::thresholdValueChanged));
        return new InputParameter("Threshold:", (JComponent)this.threshold, NcbiBlastSedaPluginInfo.PARAM_THRESHOLD_HELP_GUI);
    }

    private void thresholdValueChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.threshold.getText().isEmpty()) {
                this.threshold.setBackground(COLOR_VALID_INPUT);
                this.transformationProvider.clearThresholdValue();
            } else {
                try {
                    Integer threshold = this.getThresholdValue();
                    this.transformationProvider.setThresholdValue(threshold);
                    this.threshold.setBackground(threshold > 0 ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT);
                }
                catch (NumberFormatException e) {
                    this.transformationProvider.setThresholdValue(-1);
                    this.threshold.setBackground(ColorUtils.COLOR_INVALID_INPUT);
                }
            }
        });
    }

    private Integer getThresholdValue() {
        return Integer.parseInt(this.threshold.getText());
    }

    public NcbiBlastTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(NcbiBlastTransformationProvider transformationProvider) {
        Integer threshold;
        Integer wordSize;
        Integer hitListSize;
        Double expectValue;
        FilterParameter filter;
        MatrixParameter matrix;
        OutputTypeParameter outputType;
        NcbiBlastDatabase blastDatabase;
        this.transformationProvider = transformationProvider;
        NcbiBlastType blastType = this.transformationProvider.getBlastType();
        if (blastType != null) {
            this.blastTypeCombobox.setSelectedItem((Object)blastType);
        }
        if ((blastDatabase = this.transformationProvider.getBlastDatabase()) != null) {
            this.blastDatabaseCombobox.setSelectedItem((Object)blastDatabase);
        }
        if ((outputType = this.transformationProvider.getOutputType()) != null) {
            this.outputTypeParameter.setSelectedItem((Object)outputType);
        }
        if ((matrix = this.transformationProvider.getMatrix()) != null) {
            this.matrixCombobox.setSelectedItem(matrix);
        }
        if ((filter = this.transformationProvider.getFilter()) != null) {
            this.useFilter.setSelected(filter.isUseFilter());
            this.lookupMask.setSelected(filter.isMaskAtLookup());
        }
        if ((expectValue = this.transformationProvider.getExpectValue()) != null) {
            this.expectValue.setValue((Object)expectValue);
        }
        if ((hitListSize = this.transformationProvider.getHitListSize()) != null) {
            this.hitListSize.setValue((Object)hitListSize);
        }
        if ((wordSize = this.transformationProvider.getWordSize()) != null) {
            this.wordSize.setValue((Object)wordSize);
        }
        if ((threshold = this.transformationProvider.getThreshold()) != null) {
            this.threshold.setValue((Object)threshold);
        }
    }
}

