/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import org.sing_group.seda.blast.datatype.SequenceType;

public enum NcbiBlastType {
    BLASTN("blastn", SequenceType.NUCLEOTIDES),
    BLASTP("blastp", SequenceType.PROTEINS),
    BLASTX("blastx", SequenceType.PROTEINS),
    TBLASTN("tblastn", SequenceType.NUCLEOTIDES),
    TBLASTX("tblastx", SequenceType.NUCLEOTIDES),
    MEGABLAST("blastn&MEGABLAST=on", SequenceType.NUCLEOTIDES);

    private String program;
    private SequenceType databaseType;

    private NcbiBlastType(String program, SequenceType databaseType) {
        this.program = program;
        this.databaseType = databaseType;
    }

    public String getProgram() {
        return this.program;
    }

    public SequenceType getDatabaseType() {
        return this.databaseType;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

