/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.execution;

import java.util.function.Function;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastEnvironment;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.BinaryCheckingUtils;

public class BlastBinariesChecker {
    public static void checkBlastPath(Function<String, String> composeBlastCommand) throws BinaryCheckException {
        BlastBinariesChecker.checkMakeBlastDb(composeBlastCommand);
        BlastBinariesChecker.checkBlastDbCmd(composeBlastCommand);
        BlastBinariesChecker.checkBlastDbAliasTool(composeBlastCommand);
        BlastBinariesChecker.checkBlastCommands(composeBlastCommand);
    }

    private static void checkMakeBlastDb(Function<String, String> composeBlastCommand) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(composeBlastCommand.apply(BlastEnvironment.getInstance().getMakeBlastDbCommand() + " -version"), 2);
    }

    private static void checkBlastDbCmd(Function<String, String> composeBlastCommand) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(composeBlastCommand.apply(BlastEnvironment.getInstance().getBlastDbCmdCommand() + " -version"), 2);
    }

    private static void checkBlastDbAliasTool(Function<String, String> composeBlastCommand) throws BinaryCheckException {
        BinaryCheckingUtils.checkCommand(composeBlastCommand.apply(BlastEnvironment.getInstance().getBlastDbAliasToolCommand() + " -version"), 2);
    }

    private static void checkBlastCommands(Function<String, String> composeBlastCommand) throws BinaryCheckException {
        for (BlastType blastType : BlastType.values()) {
            BinaryCheckingUtils.checkCommand(composeBlastCommand.apply(blastType.getCommand() + " -version"), 2);
        }
    }
}

