/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.filechooser;

import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JFileChooserConfiguration {
    private final List<FileFilter> filters;
    private int selectionMode;
    private boolean allowAll;
    private boolean clearSelectedFileOnShow;

    public JFileChooserConfiguration(int selectionMode) {
        this(selectionMode, Collections.emptyList(), true, false);
    }

    public JFileChooserConfiguration(int selectionMode, List<FileFilter> filters) {
        this(selectionMode, filters, true, false);
    }

    public JFileChooserConfiguration(int selectionMode, List<FileFilter> filters, boolean allowAll, boolean clearSelectedFileOnShow) {
        this.selectionMode = selectionMode;
        this.filters = filters;
        this.allowAll = allowAll;
        this.clearSelectedFileOnShow = clearSelectedFileOnShow;
    }

    public void configure(JFileChooser fileChooser) {
        File selectedFile = fileChooser.getSelectedFile();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileSelectionMode(this.selectionMode);
        fileChooser.resetChoosableFileFilters();
        for (FileFilter filter : this.filters) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setAcceptAllFileFilterUsed(this.allowAll);
        if (this.selectionMode == 1) {
            fileChooser.setCurrentDirectory(selectedFile);
        } else if (this.clearSelectedFileOnShow) {
            fileChooser.setSelectedFile(new File(""));
        } else {
            fileChooser.setSelectedFile(selectedFile);
        }
    }
}

