/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class WorkingDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Window parent;
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private JPanel content;
    private String task;
    private ImageIcon image;

    public WorkingDialog(Window parent, String title, String task) {
        this(parent, title, task, null);
    }

    public WorkingDialog(Window parent, String title, String task, ImageIcon image) {
        super(parent, title);
        this.parent = parent;
        this.task = task;
        this.image = image;
        this.initComponent();
    }

    private void initComponent() {
        this.content = new JPanel();
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.content.setLayout(new GridLayout(2, 1));
        this.taskLabel = new JLabel(this.task);
        this.taskLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.content.add(this.taskLabel);
        this.content.add(this.getProgressComponent());
        this.add(this.content);
        this.setResizable(false);
        this.setModal(false);
        this.centerDialogOnScreen();
    }

    private Component getProgressComponent() {
        if (this.image == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(false);
            this.progressBar.setIndeterminate(true);
            return this.progressBar;
        }
        return new JLabel(this.image);
    }

    public void finished(String message) {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(100);
        }
        this.taskLabel.setText(message);
    }

    protected void centerDialogOnScreen() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }
}

