/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.GridLayout;
import java.awt.Window;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_LABEL_CURRENT_TASK = "Current task:";
    private static final String DEFAULT_LABEL_TOTAL_PROGRESS = "Total progress:";
    private Window parent;
    private List<String> tasks;
    private JLabel taskLabel;
    private JProgressBar progressBar;
    private Iterator<String> tasksIterator;
    private int increment;
    private JPanel content;
    private String currentTaskLabel;
    private String totalProgressLabel;

    public JProgressDialog(Window parent, String title, List<String> tasks) {
        this(parent, title, tasks, DEFAULT_LABEL_CURRENT_TASK, DEFAULT_LABEL_TOTAL_PROGRESS);
    }

    public JProgressDialog(Window parent, String title, List<String> tasks, String currentTaskLabel) {
        this(parent, title, tasks, currentTaskLabel, DEFAULT_LABEL_TOTAL_PROGRESS);
    }

    public JProgressDialog(Window parent, String title, List<String> tasks, String currentTaskLabel, String totalProgressLabel) {
        super(parent, title);
        this.parent = parent;
        this.tasks = tasks;
        this.currentTaskLabel = currentTaskLabel;
        this.totalProgressLabel = totalProgressLabel;
        this.tasksIterator = this.tasks.iterator();
        this.increment = 100 / tasks.size();
        this.initComponent();
    }

    private void initComponent() {
        this.content = new JPanel();
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.content.setLayout(new GridLayout(2, 2));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        this.taskLabel = new JLabel(this.tasksIterator.next());
        this.content.add(new JLabel(this.currentTaskLabel));
        this.content.add(this.taskLabel);
        this.content.add(new JLabel(this.totalProgressLabel));
        this.content.add(this.progressBar);
        this.add(this.content);
        this.setResizable(false);
        this.setModal(false);
        this.centerDialogOnScreen();
    }

    public void finished(String message) {
        this.progressBar.setValue(100);
        this.taskLabel.setText(message);
    }

    public void nextTask() {
        if (this.tasksIterator.hasNext()) {
            this.progressBar.setValue(this.progressBar.getValue() + this.increment);
            this.taskLabel.setText(this.tasksIterator.next());
        } else {
            this.progressBar.setValue(100);
        }
        this.pack();
    }

    protected void centerDialogOnScreen() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }
}

