/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.sing_group.gc4s.ui.icons.Icons;

public abstract class AbstractInputJDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final ImageIcon ICON_ACCEPT = new ImageIcon(AbstractInputJDialog.class.getResource("icons/ok.png"));
    protected static final ImageIcon ICON_CANCEL = new ImageIcon(AbstractInputJDialog.class.getResource("icons/cancel.png"));
    protected static final ImageIcon ICON_HELP = Icons.ICON_INFO_2_16;
    protected boolean canceled = true;
    protected JButton okButton;
    protected JButton cancelButton;
    protected Window parent;
    private static final JFileChooser fileChooser = new JFileChooser();
    private JTextArea textArea;

    protected AbstractInputJDialog(Window parent) {
        super(parent);
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        this.setTitle(this.getDialogTitle());
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescriptionPane(), "North");
        Component inputComponents = this.getInputComponentsPane();
        JScrollPane scroll = new JScrollPane(inputComponents);
        this.add((Component)scroll, "Center");
        this.add(this.getButtonsPane(), "South");
        this.setResizable(false);
        this.centerDialogOnScreen();
        this.setModal(true);
        this.addKeyBindings();
    }

    protected JTextArea getDescriptionPane() {
        if (this.textArea == null) {
            this.textArea = new JTextArea(this.getDescription());
            this.textArea.setMargin(new Insets(10, 10, 10, 10));
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setEditable(false);
            this.textArea.setBackground(Color.WHITE);
            this.textArea.setOpaque(true);
        }
        return this.textArea;
    }

    protected Component getButtonsPane() {
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.okButton = new JButton("Ok", ICON_ACCEPT);
        this.okButton.setEnabled(false);
        this.okButton.setToolTipText("Accept");
        this.okButton.addActionListener(this::onOkButtonEvent);
        this.cancelButton = new JButton("Cancel", ICON_CANCEL);
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.addActionListener(event -> {
            this.canceled = true;
            this.dispose();
        });
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        InputMap im = this.okButton.getInputMap();
        im.put(KeyStroke.getKeyStroke("ENTER"), "pressed");
        im.put(KeyStroke.getKeyStroke("released ENTER"), "released");
        return buttonsPanel;
    }

    protected void onOkButtonEvent(ActionEvent event) {
        this.canceled = false;
        this.dispose();
    }

    protected void addKeyBindings() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "closeTheDialog");
        this.getRootPane().getActionMap().put("closeTheDialog", new AbstractAction(){
            private static final long serialVersionUID = 8360999630557775801L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractInputJDialog.this.canceled = true;
                AbstractInputJDialog.this.dispose();
            }
        });
    }

    protected void centerDialogOnScreen() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    protected JFileChooser getFileChooser() {
        return fileChooser;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void maximize() {
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
    }

    protected abstract String getDialogTitle();

    protected abstract String getDescription();

    protected abstract Component getInputComponentsPane();
}

