/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.awt.Component;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;
import org.sing_group.seda.sapp.execution.DefaultDockerSappCommands;
import org.sing_group.seda.sapp.execution.DockerSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.DockerSappCommands;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.gui.execution.DockerSappCommandsConfigurationPanel;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<SappBinariesExecutor> {
    private static final long serialVersionUID = 1L;
    private DockerSappCommandsConfigurationPanel sappCommandsConfigurationPanel;
    private static final String SAPP_DEFAULT_DOCKER_IMAGE;
    private static final String SAPP_DEFAULT_DOCKER_SAPP_JARS_PATH;

    public DockerExecutionConfigurationPanel() {
        super(SAPP_DEFAULT_DOCKER_IMAGE, SappAnnotationSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
        this.init();
    }

    private void init() {
        this.sappCommandsConfigurationPanel = new DockerSappCommandsConfigurationPanel("", SAPP_DEFAULT_DOCKER_SAPP_JARS_PATH);
        this.sappCommandsConfigurationPanel.setControlsEnabled(false);
        this.add((Component)this.sappCommandsConfigurationPanel, "Center");
        this.dockerImage.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                DockerExecutionConfigurationPanel.this.dockerImageChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                DockerExecutionConfigurationPanel.this.dockerImageChanged();
            }
        });
    }

    private void dockerImageChanged() {
        boolean isDefaultDockerImage = this.isDefaultDockerImage();
        this.sappCommandsConfigurationPanel.setControlsEnabled(!isDefaultDockerImage);
        if (isDefaultDockerImage) {
            this.sappCommandsConfigurationPanel.setSappCommands(new DefaultDockerSappCommands());
        }
    }

    private boolean isDefaultDockerImage() {
        return this.getSelectedDockerImage().equals(SAPP_DEFAULT_DOCKER_IMAGE);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<SappBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "SAPP jars checked successfully.", "Check SAPP jars", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking SAPP jars: " + e.getCommand() + ".", "Error checking SAPP jars", 0);
        }
    }

    @Override
    public Optional<SappBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerSappBinariesExecutor(this.dockerSappCommands(selectedDockerImage)));
    }

    private DockerSappCommands dockerSappCommands(String selectedDockerImage) {
        if (this.isDefaultDockerImage()) {
            return new DefaultDockerSappCommands();
        }
        if (this.sappCommandsConfigurationPanel.selectedJavaPath().isPresent()) {
            return new DefaultDockerSappCommands(this.sappCommandsConfigurationPanel.selectedJavaPath().get() + "/java", this.sappCommandsConfigurationPanel.conversionJarPath(), this.sappCommandsConfigurationPanel.geneCallerJarPath(), selectedDockerImage);
        }
        return new DefaultDockerSappCommands(this.sappCommandsConfigurationPanel.conversionJarPath(), this.sappCommandsConfigurationPanel.geneCallerJarPath(), selectedDockerImage);
    }

    public void setSappCommands(DockerSappCommands dockerSappCommands) {
        this.setSelectedDockerImage(dockerSappCommands.dockerImage());
        this.sappCommandsConfigurationPanel.setSappCommands(dockerSappCommands);
    }

    static {
        DefaultDockerSappCommands sappCommands = new DefaultDockerSappCommands();
        SAPP_DEFAULT_DOCKER_IMAGE = sappCommands.dockerImage();
        SAPP_DEFAULT_DOCKER_SAPP_JARS_PATH = sappCommands.jarsPath().replace("\\", "/");
    }
}

