/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.entry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.ac.AcLineConverter;
import uk.ac.ebi.uniprot.parser.impl.ac.UniProtAcLineObject;
import uk.ac.ebi.uniprot.parser.impl.cc.CcLineConverter;
import uk.ac.ebi.uniprot.parser.impl.de.DeLineConverter;
import uk.ac.ebi.uniprot.parser.impl.dr.DrLineConverter;
import uk.ac.ebi.uniprot.parser.impl.dr.UniProtDrObjects;
import uk.ac.ebi.uniprot.parser.impl.dt.DtLineConverter;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.impl.entry.ReferenceObjectConverter;
import uk.ac.ebi.uniprot.parser.impl.ft.FtLineConverter;
import uk.ac.ebi.uniprot.parser.impl.gn.GnLineConverter;
import uk.ac.ebi.uniprot.parser.impl.id.IdLineConverter;
import uk.ac.ebi.uniprot.parser.impl.kw.KwLineConverter;
import uk.ac.ebi.uniprot.parser.impl.oc.OcLineConverter;
import uk.ac.ebi.uniprot.parser.impl.og.OgLineConverter;
import uk.ac.ebi.uniprot.parser.impl.oh.OhLineConverter;
import uk.ac.ebi.uniprot.parser.impl.os.OsLineConverter;
import uk.ac.ebi.uniprot.parser.impl.ox.OxLineConverter;
import uk.ac.ebi.uniprot.parser.impl.pe.PeLineConverter;
import uk.ac.ebi.uniprot.parser.impl.sq.SqLineConverter;
import uk.ac.ebi.uniprot.parser.impl.ss.SsLineConverter;
import uk.ac.ebi.uniprot.parser.impl.ss.UniProtSsLineObject;

public class EntryObjectConverter
implements Converter<EntryObject, UniProtEntry> {
    private final AcLineConverter acLineConverter = new AcLineConverter();
    private final CcLineConverter ccLineConverter = new CcLineConverter();
    private final DeLineConverter deLineConverter = new DeLineConverter();
    private final DtLineConverter dtLineConverter = new DtLineConverter();
    private final FtLineConverter ftLineConverter = new FtLineConverter();
    private final GnLineConverter gnLineConverter = new GnLineConverter();
    private final IdLineConverter idLineConverter = new IdLineConverter();
    private final KwLineConverter kwLineConverter = new KwLineConverter();
    private final OcLineConverter ocLineConverter = new OcLineConverter();
    private final OgLineConverter ogLineConverter = new OgLineConverter();
    private final OhLineConverter ohLineConverter = new OhLineConverter();
    private final OsLineConverter osLineConverter = new OsLineConverter();
    private final OxLineConverter oxLineConverter = new OxLineConverter();
    private final PeLineConverter peLineConverter = new PeLineConverter();
    private final SqLineConverter sqLineConverter = new SqLineConverter();
    private final SsLineConverter ssLineConverter = new SsLineConverter();
    private final ReferenceObjectConverter refObjConverter = new ReferenceObjectConverter();
    private final DrLineConverter drLineConverter;

    public EntryObjectConverter() {
        this.drLineConverter = new DrLineConverter();
    }

    public EntryObjectConverter(boolean ignoreWrongDR) {
        this.drLineConverter = new DrLineConverter(ignoreWrongDR);
    }

    @Override
    public UniProtEntry convert(EntryObject f) {
        this.clear();
        UniProtEntry entry = this.idLineConverter.convert(f.id);
        UniProtAcLineObject acLineObj = this.acLineConverter.convert(f.ac);
        entry.setPrimaryUniProtAccession(acLineObj.primaryAccession);
        entry.setSecondaryUniProtAccessions(acLineObj.secondAccessions);
        entry.setEntryAudit(this.dtLineConverter.convert(f.dt));
        if (f.cc != null) {
            entry.setComments(this.ccLineConverter.convert(f.cc));
        }
        entry.setProteinDescription(this.deLineConverter.convert(f.de));
        UniProtDrObjects drObjects = this.drLineConverter.convert(f.dr);
        entry.setDatabaseCrossReferences(drObjects.drObjects);
        if (f.ft != null) {
            entry.setFeatures(this.ftLineConverter.convert(f.ft));
        }
        if (f.gn != null) {
            entry.setGenes(this.gnLineConverter.convert(f.gn));
        }
        if (f.kw != null) {
            entry.setKeywords(this.kwLineConverter.convert(f.kw));
        }
        entry.setTaxonomy(this.ocLineConverter.convert(f.oc));
        if (f.og != null) {
            entry.setOrganelles(this.ogLineConverter.convert(f.og));
        }
        if (f.oh != null) {
            entry.setOrganismHosts(this.ohLineConverter.convert(f.oh));
        }
        entry.setOrganism(this.osLineConverter.convert(f.os));
        entry.getNcbiTaxonomyIds().add(this.oxLineConverter.convert(f.ox));
        entry.setProteinExistence(this.peLineConverter.convert(f.pe));
        entry.setSequence(this.sqLineConverter.convert(f.sq));
        ArrayList<Citation> citations = new ArrayList<Citation>();
        for (EntryObject.ReferenceObject refObj : f.ref) {
            citations.add(this.refObjConverter.convert(refObj));
        }
        entry.setCitationsNew(citations);
        if (drObjects.ssProsites != null) {
            entry.getInternalSection().getInternalLines().addAll(drObjects.ssProsites);
        }
        List<Evidence> ssEvidences = null;
        if (f.ss != null) {
            UniProtSsLineObject usl = this.ssLineConverter.convert(f.ss);
            if (usl.internalSection != null) {
                entry.getInternalSection().getInternalLines().addAll(usl.internalSection.getInternalLines());
                entry.getInternalSection().getSourceLines().addAll(usl.internalSection.getSourceLines());
            }
            ssEvidences = usl.evidences;
        }
        entry.setEvidences(this.buildEvidences(ssEvidences));
        return entry;
    }

    private void clear() {
        this.ccLineConverter.clear();
        this.deLineConverter.clear();
        this.ftLineConverter.clear();
        this.gnLineConverter.clear();
        this.kwLineConverter.clear();
        this.ogLineConverter.clear();
        this.oxLineConverter.clear();
        this.refObjConverter.clear();
        this.drLineConverter.clear();
    }

    private List<Evidence> buildEvidences(List<Evidence> ssEvidences) {
        ArrayList<Evidence> evidences = new ArrayList<Evidence>();
        HashSet<EvidenceId> evidenceIds = new HashSet<EvidenceId>();
        evidenceIds.addAll(this.ccLineConverter.getEvidences());
        evidenceIds.addAll(this.deLineConverter.getEvidences());
        evidenceIds.addAll(this.ftLineConverter.getEvidences());
        evidenceIds.addAll(this.gnLineConverter.getEvidences());
        evidenceIds.addAll(this.kwLineConverter.getEvidences());
        evidenceIds.addAll(this.ogLineConverter.getEvidences());
        evidenceIds.addAll(this.oxLineConverter.getEvidences());
        evidenceIds.addAll(this.refObjConverter.getEvidences());
        evidenceIds.addAll(this.drLineConverter.getEvidences());
        ArrayList<EvidenceId> evIds = new ArrayList<EvidenceId>();
        evIds.addAll(evidenceIds);
        Collections.sort(evIds);
        if (ssEvidences == null) {
            for (EvidenceId id : evIds) {
                evidences.add(EvidenceHelper.convert(id));
            }
        } else {
            for (EvidenceId id : evIds) {
                Evidence found = null;
                for (Evidence ev : ssEvidences) {
                    if (!ev.getEvidenceId().equals(id)) continue;
                    found = ev;
                    break;
                }
                if (found != null) {
                    evidences.add(found);
                    continue;
                }
                evidences.add(EvidenceHelper.convert(id));
            }
        }
        return evidences;
    }
}

