/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.dr;

import java.util.ArrayList;
import uk.ac.ebi.uniprot.parser.ParseException;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.DrLineParser;
import uk.ac.ebi.uniprot.parser.antlr.DrLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.dr.DrLineObject;

public class DrLineModelListener
extends DrLineParserBaseListener
implements ParseTreeObjectExtractor<DrLineObject> {
    private DrLineObject object;

    @Override
    public DrLineObject getObject() {
        return this.object;
    }

    @Override
    public void enterDr_dr(DrLineParser.Dr_drContext ctx) {
        this.object = new DrLineObject();
    }

    @Override
    public void exitDr_prosite_ss(DrLineParser.Dr_prosite_ssContext ctx) {
        String text;
        DrLineObject.DrObject drObject = new DrLineObject.DrObject();
        drObject.dbName = "PROSITE";
        drObject.ssLineValue = text = ctx.ATTRIBUTES().getText();
        this.object.drObjects.add(drObject);
    }

    @Override
    public void exitDr_line(DrLineParser.Dr_lineContext ctx) {
        String text1;
        DrLineObject.DrObject drObject = new DrLineObject.DrObject();
        drObject.dbName = text1 = ctx.DB_NAME().getText();
        String text = ctx.ATTRIBUTES().getText();
        this.parseDRHardWay(drObject, text);
        this.object.drObjects.add(drObject);
    }

    private void parseDRHardWay(DrLineObject.DrObject drObject, String text) {
        int index = text.indexOf("; ");
        while (index > 0) {
            String attr = text.substring(0, index);
            drObject.attributes.add(attr);
            text = text.substring(index + 2);
            index = text.indexOf("; ");
        }
        if (text.endsWith("}")) {
            int evIndex = text.indexOf(123);
            if (evIndex > 0) {
                String evidence = text.substring(evIndex + 1, text.length() - 1);
                this.processEvidence(this.object, drObject, evidence);
                text = text.substring(0, evIndex).trim();
            } else {
                throw new ParseException("Evidence tag without opening {", text, 0, 0, null);
            }
        }
        if (text.endsWith("]")) {
            int evIndex = text.indexOf(91);
            if (evIndex > 0) {
                String isoform;
                drObject.isoform = isoform = text.substring(evIndex + 1, text.length() - 1);
                text = text.substring(0, evIndex).trim();
            } else {
                throw new ParseException("Isoform tag without opening [", text, 0, 0, null);
            }
        }
        if (!text.endsWith(".")) {
            throw new ParseException("No proper ending for DR attributes", text, 0, 0, null);
        }
        String attr = text.substring(0, text.length() - 1);
        drObject.attributes.add(attr);
    }

    private void processEvidence(DrLineObject line, DrLineObject.DrObject dr, String evidence) {
        ArrayList<String> evs = new ArrayList<String>();
        int index = evidence.indexOf(44);
        while (index > 0) {
            String attr = evidence.substring(0, index);
            evs.add(attr.trim());
            evidence = evidence.substring(index + 1);
            index = evidence.indexOf(44);
        }
        evs.add(evidence);
        EvidenceInfo.processEvidenceString(line.getEvidenceInfo(), dr, evs);
    }
}

