/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.gocache;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.GoFactory;
import uk.ac.ebi.kraken.interfaces.go.GoId;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.model.factories.DefaultGoFactoryImpl;
import uk.ac.ebi.kraken.model.go.GoTermNode;
import uk.ac.ebi.uniprot.parser.gocache.GoRelationFileReader;
import uk.ac.ebi.uniprot.parser.gocache.GoTermDownload;
import uk.ac.ebi.uniprot.parser.gocache.GoTermFileReader;

public class GoTermNodeCache {
    private Map<GoId, GoTermNode> gotermNodeMap = new HashMap<GoId, GoTermNode>();
    private final GoFactory factory = DefaultGoFactoryImpl.getInstance();
    private static GoTermNodeCache INSTANCE = null;
    private static final String GO_RELATION_FILENAME = "GO.relations";
    private static final String GO_TERM_FILENAME = "GO.active_terms";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GoTermNodeCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<GoTermNodeCache> clazz = GoTermNodeCache.class;
        synchronized (GoTermNodeCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GoTermNodeCache();
            INSTANCE.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private GoTermNodeCache() {
    }

    public Optional<GoTerm> getGoTerm(GoId goId) {
        Optional<GoTermNode> node = this.getGoTermNode(goId);
        return node.isPresent() ? Optional.of(node.get().getTerm()) : Optional.empty();
    }

    public Optional<GoTermNode> getGoTermNode(GoId goId) {
        GoTermNode node = this.gotermNodeMap.get(goId);
        return Optional.ofNullable(node);
    }

    public Optional<GoTerm> getGoTerm(String goId) {
        return this.getGoTerm(this.factory.buildGoId(goId));
    }

    public Optional<GoTermNode> getGoTermNode(String goId) {
        return this.getGoTermNode(this.factory.buildGoId(goId));
    }

    private void build() {
        String tempPath = ".";
        try {
            GoTermDownload download = new GoTermDownload(tempPath);
            download.connect();
            List<String> files = download.download();
            System.out.println(files);
            download.close();
            String goRelationFile = tempPath + File.separator + GO_RELATION_FILENAME;
            if (!files.contains(goRelationFile)) {
                throw new RuntimeException("Go relation file does not exist.");
            }
            GoRelationFileReader relationReader = new GoRelationFileReader(goRelationFile);
            relationReader.read();
            String goTermFile = tempPath + File.separator + GO_TERM_FILENAME;
            if (!files.contains(goTermFile)) {
                throw new RuntimeException("Go term file does not exist.");
            }
            GoTermFileReader termReader = new GoTermFileReader(goTermFile);
            List<GoTerm> goTerms = termReader.read();
            this.gotermNodeMap = goTerms.stream().map(val -> this.convertToNode((GoTerm)val, relationReader)).collect(Collectors.toMap(val -> val.getTerm().getGoId(), val -> val));
            this.deleteTempFiles(files);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteTempFiles(List<String> files) throws IOException {
        for (String inputFile : files) {
            File file = new File(inputFile);
            Files.deleteIfExists(file.toPath());
        }
    }

    private GoTermNode convertToNode(GoTerm term, GoRelationFileReader relationReader) {
        GoTermNode node = new GoTermNode(term);
        node.getIsAParents().addAll(relationReader.getIsAParentMap().getOrDefault(term.getGoId(), Collections.emptyList()));
        node.getPartOfAParents().addAll(relationReader.getIsPartParentMap().getOrDefault(term.getGoId(), Collections.emptyList()));
        node.getIsAChildren().addAll(relationReader.getIsAChildMap().getOrDefault(term.getGoId(), Collections.emptyList()));
        node.getPartOfChildren().addAll(relationReader.getIsPartChildMap().getOrDefault(term.getGoId(), Collections.emptyList()));
        return node;
    }
}

