/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser;

import com.google.common.base.Strings;

public class ParseException
extends RuntimeException {
    private final String originalString;
    private final int currentLineNumber;
    private final int currentCharPosition;

    public ParseException(String message, String originalString, int currentLineNumber, int currentCharPosition, Throwable e) {
        super(message, e);
        this.originalString = originalString;
        this.currentLineNumber = currentLineNumber;
        this.currentCharPosition = currentCharPosition;
    }

    public String getDetailedMessage() {
        String errorMessage = String.format("Parsing Error while parsing the input String parsing error message is: \n %s \n", super.getMessage());
        if (!Strings.isNullOrEmpty((String)this.originalString)) {
            String[] split = this.originalString.split("\n");
            String display = this.originalString;
            if (this.currentLineNumber > 0 && this.currentLineNumber - 1 < split.length) {
                display = split[this.currentLineNumber - 1];
            }
            errorMessage = errorMessage + String.format("Error happen on [%d:%d] of the original string. The error line is: \n %s", this.currentLineNumber, this.currentCharPosition, display);
        }
        return errorMessage;
    }

    public String getOriginalString() {
        return this.originalString;
    }
}

