/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.JournalArticle;

public class JournalArticleUpdater
implements CitationUpdater {
    private final DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public Object convertToAvro(Citation ci) {
        if (!(ci instanceof JournalArticle)) {
            return new Object();
        }
        JournalArticle val = (JournalArticle)ci;
        JournalArticle.Builder builder = uk.ac.ebi.uniprot.services.data.serializer.model.ref.JournalArticle.newBuilder();
        builder.setName(val.getJournalName().getValue());
        String page = val.getFirstPage().getValue() + "=" + val.getLastPage();
        builder.setPage(page);
        builder.setVolume(val.getVolume().getValue());
        return builder.build();
    }

    @Override
    public Citation update(Citation ci, Object obj) {
        if (!(ci instanceof JournalArticle)) {
            return ci;
        }
        JournalArticle val = (JournalArticle)ci;
        uk.ac.ebi.uniprot.services.data.serializer.model.ref.JournalArticle data = (uk.ac.ebi.uniprot.services.data.serializer.model.ref.JournalArticle)((Object)obj);
        String[] pages = data.getPage().toString().split("=");
        val.setFirstPage(this.factory.buildPage(pages[0]));
        if (pages.length > 1) {
            val.setLastPage(this.factory.buildPage(pages[1]));
        }
        val.setJournalName(this.factory.buildJournalName(data.getName().toString()));
        val.setVolume(this.factory.buildVolume(data.getVolume().toString()));
        return val;
    }
}

