/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.WebResource;

public class WebResourceCommentConverter
extends AbstractCommentConverter<WebResourceComment> {
    private static final String FTP = "ftp";

    @Override
    protected Object convertToAvro(WebResourceComment u) {
        WebResource.Builder builder = WebResource.newBuilder();
        if (!Strings.isNullOrEmpty((String)u.getMolecule())) {
            builder.setMolecule(u.getMolecule());
        }
        builder.setName(u.getDatabaseName().getValue());
        builder.setNote(u.getDatabaseNote().getValue());
        if (u.getDatabaseURL().getValue().isEmpty()) {
            builder.setUrl(u.getDatabaseFTP().getValue());
        } else {
            builder.setUrl(u.getDatabaseURL().getValue());
        }
        return builder.build();
    }

    @Override
    protected WebResourceComment convertFromAvro(CommentType type, Object avroObj) {
        WebResourceComment comment = (WebResourceComment)factory.buildComment(type);
        WebResource wr = (WebResource)((Object)avroObj);
        if (wr.getMolecule() != null) {
            comment.setMolecule(wr.getMolecule().toString());
        }
        comment.setDatabaseName(factory.buildDatabaseName(wr.getName().toString()));
        comment.setDatabaseNote(factory.buildDatabaseNote(wr.getNote().toString()));
        if (comment.getDatabaseURL().toString().startsWith(FTP)) {
            comment.setDatabaseFTP(factory.buildDatabaseFTP(wr.getUrl().toString()));
        } else {
            comment.setDatabaseURL(factory.buildDatabaseURL(wr.getUrl().toString()));
        }
        return comment;
    }
}

