/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.SubCellLocationConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Location;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.SubcullarLocation;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class SubcellularLocationCommentConverter
extends AbstractCommentConverter<SubcellularLocationComment> {
    private final SubCellLocationConverter locationConverter = new SubCellLocationConverter();

    @Override
    protected Object convertToAvro(SubcellularLocationComment u) {
        SubcullarLocation.Builder builder = SubcullarLocation.newBuilder();
        if (!Strings.isNullOrEmpty((String)u.getMolecule())) {
            builder.setMolecule(u.getMolecule());
        }
        if (u.getSubcellularLocationNote() != null && !u.getSubcellularLocationNote().getTexts().isEmpty()) {
            builder.setNote(u.getSubcellularLocationNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        builder.setLocations(u.getSubcellularLocations().stream().map(a -> this.locationConverter.toAvro((SubcellularLocation)a)).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    protected SubcellularLocationComment convertFromAvro(CommentType type, Object avroObj) {
        SubcellularLocationComment comment = (SubcellularLocationComment)factory.buildComment(type);
        SubcullarLocation subLocation = (SubcullarLocation)((Object)avroObj);
        if (subLocation.getMolecule() != null) {
            comment.setMolecule(subLocation.getMolecule().toString());
        }
        if (subLocation.getNote() != null) {
            SubcellularLocationNote note = factory.buildSubcellularLocationNote();
            note.setTexts(subLocation.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
            comment.setSubcellularLocationNote(note);
        }
        comment.setSubcellularLocations(subLocation.getLocations().stream().map(loc -> this.locationConverter.fromAvro((Location)((Object)loc))).collect(Collectors.toList()));
        return comment;
    }
}

