/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.MassSpectrometry;

public class MassSpectrometryCommentConverter
extends AbstractCommentConverter<MassSpectrometryComment> {
    @Override
    protected Object convertToAvro(MassSpectrometryComment u) {
        MassSpectrometry.Builder builder = MassSpectrometry.newBuilder();
        if (!Strings.isNullOrEmpty((String)u.getMolecule())) {
            builder.setMolecule(u.getMolecule());
        }
        builder.setSources(u.getSources().stream().map(s -> s.getValue()).collect(Collectors.toList()));
        builder.setMethod(u.getMethod().getValue());
        if (u.getNote() != null && !u.getNote().getValue().isEmpty()) {
            builder.setNote(u.getNote().getValue());
        }
        builder.setMass(Float.valueOf(u.getMolWeight()));
        builder.setMassError(Float.valueOf(u.getMolWeightError()));
        return builder.build();
    }

    @Override
    protected MassSpectrometryComment convertFromAvro(CommentType type, Object avroObj) {
        MassSpectrometryComment comment = (MassSpectrometryComment)factory.buildComment(type);
        MassSpectrometry ms = (MassSpectrometry)((Object)avroObj);
        if (ms.getMolecule() != null) {
            comment.setMolecule(ms.getMolecule().toString());
        }
        comment.setSources(ms.getSources().stream().map(s -> factory.buildMassSpectrometryCommentSource(s.toString())).collect(Collectors.toList()));
        comment.setEvidenceIds(evidenceConverter.fromAvro(ms.getSources()));
        comment.setMethod(MassSpectrometryMethod.toType(ms.getMethod().toString()));
        if (ms.getNote() != null) {
            comment.setNote(factory.buildMassSpectrometryCommentNote(ms.getNote().toString()));
        }
        comment.setMolWeight(((Float)ms.getMass()).floatValue());
        comment.setMolWeightError(ms.getMassError().floatValue());
        return comment;
    }
}

