/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidencedStringConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.BPCPMaximumVelocityConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.BPCPMichaelisConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Kinetics;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class BPCPKineticsConverter
implements Converter<KineticParameters, Kinetics> {
    private final BPCPMaximumVelocityConverter mvConverter = new BPCPMaximumVelocityConverter();
    private final BPCPMichaelisConverter michaelisConverter = new BPCPMichaelisConverter();
    private final EvidencedStringConverter evidencedStringConverter = new EvidencedStringConverter();

    @Override
    public Kinetics toAvro(KineticParameters kp) {
        Kinetics.Builder kmBuilder = Kinetics.newBuilder();
        kmBuilder.setVmax(kp.getMaximumVelocities().stream().map(v -> this.mvConverter.toAvro((MaximumVelocity)v)).collect(Collectors.toList()));
        kmBuilder.setKM(kp.getMichaelisConstants().stream().map(v -> this.michaelisConverter.toAvro((MichaelisConstant)v)).collect(Collectors.toList()));
        if (kp.hasKineticParameterNote()) {
            kmBuilder.setNote(kp.getNote().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        return kmBuilder.build();
    }

    @Override
    public KineticParameters fromAvro(Kinetics kinetics) {
        KineticParameters kp = DefaultCommentFactory.getInstance().buildKineticParameters();
        kp.setMaximumVelocities(kinetics.getVmax().stream().map(v -> this.mvConverter.fromAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
        kp.setMichaelisConstants(kinetics.getKM().stream().map(v -> this.michaelisConverter.fromAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
        if (kinetics.getNote() != null) {
            KineticParameterNote note = DefaultCommentFactory.getInstance().buildKineticParameterNote();
            note.setTexts(kinetics.getNote().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
            kp.setNote(note);
        }
        return kp;
    }
}

