/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.DescriptionFlagConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.DescriptionSectionConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.NameGroupType;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.Protein;
import uk.ac.ebi.uniprot.services.data.serializer.model.de.ProteinName;

public class DescriptionConverter
implements Converter<ProteinDescription, Protein> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private final DescriptionFlagConverter flagConverter = new DescriptionFlagConverter();
    private final DescriptionSectionConverter sectionConverter = new DescriptionSectionConverter();

    @Override
    public Protein toAvro(ProteinDescription proteinDescription) {
        Protein.Builder builder = Protein.newBuilder();
        ProteinName main = this.convertToProteinName(NameGroupType.MAIN, proteinDescription.getSection());
        ArrayList<ProteinName> proteinNames = new ArrayList<ProteinName>();
        proteinNames.add(main);
        proteinNames.addAll(proteinDescription.getContains().stream().map(section -> this.convertToProteinName(NameGroupType.CONTAIN, (Section)section)).collect(Collectors.toList()));
        proteinNames.addAll(proteinDescription.getIncludes().stream().map(section -> this.convertToProteinName(NameGroupType.INCLUDE, (Section)section)).collect(Collectors.toList()));
        builder.setProteinName(proteinNames);
        builder.setFlag(this.flagConverter.toAvro(proteinDescription.getFlags()));
        return builder.build();
    }

    private ProteinName convertToProteinName(NameGroupType type, Section section) {
        ProteinName proteinName = this.sectionConverter.toAvro(section);
        proteinName.setType(type);
        return proteinName;
    }

    @Override
    public ProteinDescription fromAvro(Protein avroProtein) {
        ProteinDescription pd = factory.buildProteinDescription();
        ArrayList<Section> containedSections = new ArrayList<Section>();
        ArrayList<Section> includedSections = new ArrayList<Section>();
        for (ProteinName ProteinName2 : avroProtein.getProteinName()) {
            Section section = this.sectionConverter.fromAvro(ProteinName2);
            switch (ProteinName2.getType()) {
                case MAIN: {
                    pd.setSection(section);
                    break;
                }
                case INCLUDE: {
                    includedSections.add(section);
                    break;
                }
                case CONTAIN: {
                    containedSections.add(section);
                }
            }
        }
        pd.setIncludes(includedSections);
        pd.setContains(containedSections);
        if (avroProtein.getFlag() != null) {
            pd.setFlags(this.flagConverter.fromAvro(avroProtein.getFlag().toString()));
        }
        return pd;
    }
}

