/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.SearchTerm;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UniProtSearchTerm
implements SearchTerm {
    private String term;
    private String type;
    private List<String> typeValues = new ArrayList<String>();
    private String displayName;
    private String description;
    private List<String> values = new ArrayList<String>();
    private String solrSearchTerm;
    private List<UniProtSearchTerm> subterms = new ArrayList<UniProtSearchTerm>();
    private boolean isRange = false;
    private boolean hasEvidence = false;

    public List<String> getTypeValues() {
        return this.typeValues;
    }

    public void setTypeValues(List<String> typeValues) {
        this.typeValues = typeValues;
    }

    @Override
    public boolean isRange() {
        return this.isRange;
    }

    public void setRange(boolean isRange) {
        this.isRange = isRange;
    }

    @Override
    public boolean hasEvidence() {
        return this.hasEvidence;
    }

    public void setHasEvidence(boolean hasEvidence) {
        this.hasEvidence = hasEvidence;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setSolrTerm(String solrTerm) {
        this.solrSearchTerm = solrTerm;
    }

    public void setSubterms(List<UniProtSearchTerm> subterms) {
        this.subterms = subterms;
    }

    public int getCount() {
        if (this.subterms.isEmpty()) {
            return 1;
        }
        return this.subterms.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        if (!Strings.isNullOrEmpty((String)this.term)) {
            sb.append("term:").append(this.term).append("\n");
        }
        if (!Strings.isNullOrEmpty((String)this.type)) {
            sb.append("type:").append(this.type).append("\n");
        }
        if (!Strings.isNullOrEmpty((String)this.displayName)) {
            sb.append("displayName:").append(this.displayName).append("\n");
        }
        if (!Strings.isNullOrEmpty((String)this.description)) {
            sb.append("description:").append(this.description).append("\n");
        }
        if (!Strings.isNullOrEmpty((String)this.solrSearchTerm)) {
            sb.append("solrTerm:").append(this.solrSearchTerm).append("\n");
        }
        if (!this.typeValues.isEmpty()) {
            sb.append("typeValues:[\n");
            this.typeValues.forEach(val -> sb.append("\t").append((String)val).append("\n"));
            sb.append("]\n");
        }
        if (!this.values.isEmpty()) {
            sb.append("values:[\n");
            this.values.forEach(val -> sb.append("\t").append((String)val).append("\n"));
            sb.append("]\n");
        }
        if (this.isRange) {
            sb.append("isRange: true\n");
        }
        if (this.hasEvidence) {
            sb.append("hasEvidence: true\n");
        }
        if (!this.subterms.isEmpty()) {
            sb.append("subterms:[");
            this.subterms.forEach(val -> sb.append(val).append("\n"));
            sb.append("]\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getTerm() {
        return this.term;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getSolrSearchTerm() {
        return this.solrSearchTerm;
    }

    @Override
    public List<SearchTerm> getSubTerms() {
        ArrayList<SearchTerm> values = new ArrayList<SearchTerm>();
        values.addAll(this.subterms);
        return values;
    }
}

