/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.UniProtEntryStoreResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.UniProtServiceImpl;
import uk.ac.ebi.uniprot.dataservice.document.uniprot.UniProtDocument;
import uk.ac.ebi.uniprot.dataservice.voldemort.VoldemortClient;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniprot.VoldemortInMemoryUniprotEntryStore;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniprot.VoldemortRemoteUniprotEntryStore;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;

public class UniProtGuiceModule
extends AbstractModule {
    public static final String UNIPROT_SERVICE_URL = "uniprotServiceURL";
    private final String serviceUrl;
    private final String voldemortUrl;
    private final String voldemortStoreName;
    private final String avroBinaryDocumentFieldName;
    private final String documentId;

    public UniProtGuiceModule(Properties configProperties) {
        this.serviceUrl = configProperties.getProperty(UNIPROT_SERVICE_URL);
        this.voldemortUrl = configProperties.getProperty("uniprotVoldemortUrl");
        this.voldemortStoreName = configProperties.getProperty("uniprotVoldemortStoreName");
        this.avroBinaryDocumentFieldName = configProperties.getProperty("uniprotAvroFieldName");
        this.documentId = configProperties.getProperty("uniprotDocumentId");
    }

    protected void configure() {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"UNIPROT_REMOTE_SERVER_URL")).to(this.serviceUrl);
        this.bind(UniProtService.class).to(UniProtServiceImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniprotAvroFieldName")).to(this.avroBinaryDocumentFieldName);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniprotDocumentId")).to(this.documentId);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniprotVoldemortUrl")).to(this.voldemortUrl);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniprotVoldemortStoreName")).to(this.voldemortStoreName);
        if (this.voldemortUrl.equals("inMemory")) {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<EntryObject>>(){}).toInstance((Object)VoldemortInMemoryUniprotEntryStore.getInstance((String)this.voldemortStoreName));
        } else {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<EntryObject>>(){}).toInstance((Object)new VoldemortRemoteUniprotEntryStore(this.voldemortStoreName, this.voldemortUrl));
        }
        this.getResponseFactoryMapBinder().addBinding(UniProtDocument.class).to(UniProtEntryStoreResponseFactory.class);
    }

    private MapBinder<Class<?>, ResponseFactory> getResponseFactoryMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<ResponseFactory>(){});
    }
}

