/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.DefaultUniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.EntryResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.UniProtComponentImpl;
import uk.ac.ebi.uniprot.dataservice.document.uniprot.UniProtDocument;

class ResponseAdaptors {
    public static final GeneResponseAdaptor geneAdaptor = new GeneResponseAdaptor();
    public static final XrefResponseAdaptor xrefAdaptor = new XrefResponseAdaptor();
    public static final EcNumberResponseAdaptor ecNumberAdaptor = new EcNumberResponseAdaptor();
    public static final ProteinNameResponseAdaptor proteinNameAdaptor = new ProteinNameResponseAdaptor();
    public static final CommentResponseAdaptor commentAdaptor = new CommentResponseAdaptor();
    public static final AccessionResponseAdaptor accessionAdaptor = new AccessionResponseAdaptor();
    public static final EntryResponseAdaptor entryAdaptor = EntryResponseAdaptor.getInstance();
    public static final FeatureResponseAdaptor featureAdaptor = new FeatureResponseAdaptor();
    public static final KeywordResponseAdaptor keywordAdaptor = new KeywordResponseAdaptor();

    ResponseAdaptors() {
    }

    public static final QueryResponseAdaptor UniProtDataAdaptor(UniProtData.ComponentType[] types) {
        return new QueryResponseAdaptor(types);
    }

    private static List<Comment> convertComments(UniProtEntry entry) {
        return entry.getComments().stream().collect(Collectors.toList());
    }

    private static List<Gene> convertGenes(UniProtEntry entry) {
        return entry.getGenes();
    }

    private static List<Feature> convertFeatures(UniProtEntry entry) {
        return entry.getFeatures();
    }

    private static List<Keyword> convertKeywords(UniProtEntry entry) {
        return entry.getKeywords();
    }

    private static List<DatabaseCrossReference> convertXrefs(UniProtEntry entry) {
        return entry.getDatabaseCrossReferences().stream().collect(Collectors.toList());
    }

    private static List<String> convertProteinName(UniProtEntry entry) {
        ProteinDescription proteinDescription = entry.getProteinDescription();
        Collection<Section> sections = ResponseAdaptors.aggregateProteinNameSections(proteinDescription);
        return ResponseAdaptors.extractNameValuesFromSections(sections, EnumSet.complementOf(EnumSet.of(FieldType.EC)));
    }

    private static List<String> convertEcNumber(UniProtEntry entry) {
        ProteinDescription proteinDescription = entry.getProteinDescription();
        Collection<Section> sections = ResponseAdaptors.aggregateProteinNameSections(proteinDescription);
        return ResponseAdaptors.extractNameValuesFromSections(sections, EnumSet.of(FieldType.EC));
    }

    private static Collection<Section> aggregateProteinNameSections(ProteinDescription proteinDescription) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (proteinDescription != null) {
            sections.add(proteinDescription.getSection());
            sections.addAll(proteinDescription.getIncludes());
            sections.addAll(proteinDescription.getContains());
        }
        return sections;
    }

    private static List<String> extractNameValuesFromSections(Collection<Section> sections, EnumSet<FieldType> fieldsToExtract) {
        List<String> extractedNames = new ArrayList<String>();
        if (sections != null) {
            extractedNames = sections.stream().map(Section::getNames).flatMap(Collection::stream).map(Name::getFields).flatMap(Collection::stream).filter(field -> fieldsToExtract.contains((Object)field.getType())).map(Value::getValue).collect(Collectors.toList());
        }
        return extractedNames;
    }

    static class AccessionResponseAdaptor
    implements ResponseAdaptor<PrimaryUniProtAccession, UniProtDocument> {
        AccessionResponseAdaptor() {
        }

        @Override
        public PrimaryUniProtAccession adapt(UniProtDocument doc) {
            return DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(doc.accession);
        }
    }

    static class KeywordResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Keyword>, UniProtDocument> {
        KeywordResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Keyword> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List keywords = ResponseAdaptors.convertKeywords(entry);
            return new UniProtComponentImpl<Keyword>(entry.getPrimaryUniProtAccession(), keywords);
        }
    }

    static class FeatureResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Feature>, UniProtDocument> {
        FeatureResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Feature> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List features = ResponseAdaptors.convertFeatures(entry);
            return new UniProtComponentImpl<Feature>(entry.getPrimaryUniProtAccession(), features);
        }
    }

    static class CommentResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Comment>, UniProtDocument> {
        CommentResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Comment> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List comments = ResponseAdaptors.convertComments(entry);
            return new UniProtComponentImpl<Comment>(entry.getPrimaryUniProtAccession(), comments);
        }
    }

    static class ProteinNameResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<String>, UniProtDocument> {
        ProteinNameResponseAdaptor() {
        }

        @Override
        public UniProtComponent<String> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List proteinNames = ResponseAdaptors.convertProteinName(entry);
            return new UniProtComponentImpl<String>(entry.getPrimaryUniProtAccession(), proteinNames);
        }
    }

    static class EcNumberResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<String>, UniProtDocument> {
        EcNumberResponseAdaptor() {
        }

        @Override
        public UniProtComponent<String> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List ecNumbers = ResponseAdaptors.convertEcNumber(entry);
            return new UniProtComponentImpl<String>(entry.getPrimaryUniProtAccession(), ecNumbers);
        }
    }

    static class XrefResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<DatabaseCrossReference>, UniProtDocument> {
        XrefResponseAdaptor() {
        }

        @Override
        public UniProtComponent<DatabaseCrossReference> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List results = ResponseAdaptors.convertXrefs(entry);
            return new UniProtComponentImpl<DatabaseCrossReference>(entry.getPrimaryUniProtAccession(), results);
        }
    }

    static class GeneResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Gene>, UniProtDocument> {
        GeneResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Gene> adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            List genes = ResponseAdaptors.convertGenes(entry);
            return new UniProtComponentImpl<Gene>(entry.getPrimaryUniProtAccession(), genes);
        }
    }

    public static class QueryResponseAdaptor
    implements ResponseAdaptor<UniProtData, UniProtDocument> {
        private final UniProtData.ComponentType[] types;

        public QueryResponseAdaptor(UniProtData.ComponentType[] types) {
            this.types = types;
        }

        @Override
        public UniProtData adapt(UniProtDocument doc) {
            UniProtEntry entry = entryAdaptor.adapt(doc);
            PrimaryUniProtAccession acc = entry.getPrimaryUniProtAccession();
            UniProtId id = entry.getUniProtId();
            DefaultUniProtData data = new DefaultUniProtData(acc, id);
            for (UniProtData.ComponentType type : this.types) {
                Object obj = this.convert(entry, type);
                if (obj == null) continue;
                data.put(type, obj);
            }
            return data;
        }

        private Object convert(UniProtEntry entry, UniProtData.ComponentType type) {
            switch (type) {
                case COMMENTS: {
                    return ResponseAdaptors.convertComments(entry);
                }
                case GENES: {
                    return entry.getGenes();
                }
                case FEATURES: {
                    return entry.getFeatures();
                }
                case KEYWORDS: {
                    return entry.getKeywords();
                }
                case ECNUMBER: {
                    return ResponseAdaptors.convertEcNumber(entry);
                }
                case PROTEIN_NAMES: {
                    return ResponseAdaptors.convertProteinName(entry);
                }
                case XREFS: {
                    return ResponseAdaptors.convertXrefs(entry);
                }
                case TAXONOMY: {
                    return entry.getTaxonomy();
                }
            }
            return null;
        }
    }
}

