/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.util.AccessionResolver;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtField;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.QueryFactory;
import uk.ac.ebi.uniprot.dataservice.query.impl.Accessor;

public class UniProtQueryBuilder {
    private static final int MAX_NUM_ACCESSION = 500;
    private static final String XREF_DYNAMIC_PREFIX = "xref_";
    private static final String COMMENT_DYNAMIC_PREFIX = "comment_";
    private static final String FEATURE_DYNAMIC_PREFIX = "feature_";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static QueryFactory factory() {
        return Accessor.getDefault().getQueryFactoryInstance();
    }

    public static Query id(String proteinId) {
        if (Strings.isNullOrEmpty((String)proteinId)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.id, proteinId);
    }

    public static Query accession(String accession) {
        if (Strings.isNullOrEmpty((String)accession)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (AccessionResolver.isUniprotAccession(accession)) {
            return UniProtQueryBuilder.query(UniProtField.Search.accession, accession.toUpperCase());
        }
        return UniProtQueryBuilder.factory().createEmptyQuery();
    }

    public static Query accessions(Set<String> accessions) {
        List validAccessions = accessions.stream().filter(ac -> !Strings.isNullOrEmpty((String)ac) && AccessionResolver.isUniprotAccession(ac)).collect(Collectors.toList());
        if (validAccessions.isEmpty()) {
            throw new IllegalArgumentException("Valid Accession is empty.");
        }
        if (validAccessions.size() > 500) {
            String message = "Number of valid Accession in the set is " + validAccessions.size() + ", but maximum allowed number of accessions in a query is " + 500 + ".";
            throw new IllegalArgumentException(message);
        }
        Query[] queries = new Query[validAccessions.size()];
        int i = 0;
        for (String accession : validAccessions) {
            queries[i] = UniProtQueryBuilder.accession(accession);
            ++i;
        }
        return UniProtQueryBuilder.or(queries);
    }

    public static Query secondaryAccession(String accession) {
        if (Strings.isNullOrEmpty((String)accession)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (AccessionResolver.isUniprotAccession(accession)) {
            return UniProtQueryBuilder.query(UniProtField.Search.sec_acc, accession);
        }
        return UniProtQueryBuilder.factory().createEmptyQuery();
    }

    public static Query anyAccession(String accession) {
        if (Strings.isNullOrEmpty((String)accession)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (AccessionResolver.isUniprotAccession(accession)) {
            Query primaryAccQuery = UniProtQueryBuilder.query(UniProtField.Search.accession, accession);
            Query secondaryAccQuery = UniProtQueryBuilder.query(UniProtField.Search.sec_acc, accession);
            return UniProtQueryBuilder.or(primaryAccQuery, secondaryAccQuery);
        }
        return UniProtQueryBuilder.factory().createEmptyQuery();
    }

    private static Query reviewed(boolean term) {
        return term ? UniProtQueryBuilder.query(UniProtField.Search.reviewed, "true") : UniProtQueryBuilder.query(UniProtField.Search.reviewed, "false");
    }

    public static Query swissprot() {
        return UniProtQueryBuilder.reviewed(true);
    }

    public static Query trembl() {
        return UniProtQueryBuilder.reviewed(false);
    }

    public static Query reviewed(Query query, boolean term) {
        Query q = term ? UniProtQueryBuilder.query(UniProtField.Search.reviewed, "true") : UniProtQueryBuilder.query(UniProtField.Search.reviewed, "false");
        return query.and(q);
    }

    public static Query created(Date fromDate, Date toDate) {
        return UniProtQueryBuilder.between(UniProtField.SearchDate.created, fromDate, toDate);
    }

    public static Query updated(Date fromDate, Date toDate) {
        if (fromDate == null && toDate == null) {
            throw new IllegalArgumentException("from-date and to-date cannot both be null.");
        }
        return UniProtQueryBuilder.between(UniProtField.SearchDate.updated, fromDate, toDate);
    }

    public static Query after(UniProtField.SearchDate dateField, Date date) {
        return UniProtQueryBuilder.betweenStr(dateField, UniProtQueryBuilder.formatDate(date), "*");
    }

    public static Query before(UniProtField.SearchDate dateField, Date date) {
        return UniProtQueryBuilder.betweenStr(dateField, "*", UniProtQueryBuilder.formatDate(date));
    }

    public static Query between(UniProtField.SearchDate dateField, Date fromDate, Date toDate) {
        if (fromDate == null || toDate == null) {
            throw new IllegalArgumentException("From or To date is null.");
        }
        String start = UniProtQueryBuilder.formatDate(fromDate);
        String end = UniProtQueryBuilder.formatDate(toDate);
        return UniProtQueryBuilder.betweenStr(dateField, start, end);
    }

    public static Query betweenStr(UniProtField.SearchDate dateField, String start, String end) {
        return UniProtQueryBuilder.factory().createRangeQuery(dateField.name(), start, true, end, true);
    }

    private static String formatDate(Date date) {
        LocalDateTime localDate = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return localDate.format(DATE_FORMAT);
    }

    public static Query proteinName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createBasicQuery(UniProtField.Search.protein_name.name(), name, false);
    }

    public static Query ec(String number) {
        if (Strings.isNullOrEmpty((String)number)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.ec, number);
    }

    public static Query fragment(boolean isFragment) {
        return isFragment ? UniProtQueryBuilder.query(UniProtField.Search.fragment, "true") : UniProtQueryBuilder.query(UniProtField.Search.fragment, "false");
    }

    public static Query gene(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.gene, name);
    }

    public static Query geneExact(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.gene_exact, name);
    }

    public static Query organismName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createBasicQuery(UniProtField.Search.organism_name.name(), name, false);
    }

    public static Query taxonID(int taxonomy) {
        return UniProtQueryBuilder.query(UniProtField.Search.organism_tax_id, String.valueOf(taxonomy));
    }

    public static Query taxonName(String taxon) {
        return UniProtQueryBuilder.query(UniProtField.Search.tax_name_lineage, taxon);
    }

    public static Query organelle(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.organelles, name);
    }

    public static Query organismHostName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.organism_host_name, name);
    }

    public static Query organismHostID(int taxonomy) {
        return UniProtQueryBuilder.query(UniProtField.Search.organism_host_tax_id, String.valueOf(taxonomy));
    }

    public static Query pubmed(String pubmedId) {
        return UniProtQueryBuilder.query(UniProtField.Search.lit_pubmed, pubmedId);
    }

    public static Query title(String referenceTitle) {
        if (Strings.isNullOrEmpty((String)referenceTitle)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.lit_titles, referenceTitle);
    }

    public static Query authors(Set<String> authors) {
        Query[] queries = new Query[authors.size()];
        int n = 0;
        for (String author : authors) {
            queries[n] = UniProtQueryBuilder.query(UniProtField.Search.lit_authors, author);
            ++n;
        }
        return UniProtQueryBuilder.and(queries);
    }

    public static Query authorGroup(String group) {
        if (Strings.isNullOrEmpty((String)group)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.lit_organisations, group);
    }

    public static Query comments(CommentType commentType, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createBasicQuery(COMMENT_DYNAMIC_PREFIX + UniProtQueryBuilder.getFieldType(commentType.name()), value, false);
    }

    public static Query commentsType(CommentType commentType) {
        return UniProtQueryBuilder.factory().createBasicQuery(COMMENT_DYNAMIC_PREFIX + UniProtQueryBuilder.getFieldType(commentType.name()), "*", false);
    }

    private static String getFieldType(String field) {
        String s = field.toLowerCase();
        return s.replaceAll(" ", "_");
    }

    public static Query goTerm(String term) {
        if (Strings.isNullOrEmpty((String)term)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.go_terms, term);
    }

    public static Query xref(DatabaseType dbType, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createPhraseQuery(XREF_DYNAMIC_PREFIX + dbType.getName().toLowerCase().toLowerCase(), value, false);
    }

    public static Query xref(DatabaseType dbType) {
        return UniProtQueryBuilder.xref(dbType, "*");
    }

    public static Query xref(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.query(UniProtField.Search.xref, value);
    }

    public static Query proteinExistence(ProteinExistence proteinExistence) {
        return UniProtQueryBuilder.factory().createPhraseQuery(UniProtField.Search.protein_existence.name(), proteinExistence.name(), false);
    }

    public static Query keyword(String keyword) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createBasicQuery(UniProtField.Search.keywords.name(), keyword, false);
    }

    public static Query featuresType(FeatureType ftType) {
        return UniProtQueryBuilder.factory().createBasicQuery(FEATURE_DYNAMIC_PREFIX + UniProtQueryBuilder.getFieldType(ftType.getName()), "*", false);
    }

    public static Query features(FeatureType featureType, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createPhraseQuery(FEATURE_DYNAMIC_PREFIX + UniProtQueryBuilder.getFieldType(featureType.getName()), value, false);
    }

    public static Query query(UniProtField.Search field, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniProtQueryBuilder.factory().createPhraseQuery(field.name(), value, false);
    }

    public static Query seqLength(int length) {
        return UniProtQueryBuilder.query(UniProtField.Search.length, "" + length);
    }

    public static Query seqLengthRange(int start, int end) {
        return UniProtQueryBuilder.factory().createRangeQuery(UniProtField.Search.length.name(), "" + start, true, "" + end, true);
    }

    public static Query and(Query ... subQueries) {
        return UniProtQueryBuilder.factory().and(subQueries);
    }

    public static Query or(Query ... subQueries) {
        return UniProtQueryBuilder.factory().or(subQueries);
    }

    public static Query not(UniProtField.Search field, String value) {
        return UniProtQueryBuilder.factory().createPhraseQuery(field.name(), value, true);
    }

    public static Query isoformOnly() {
        return UniProtQueryBuilder.factory().createBasicQuery(UniProtField.Search.is_isoform.name(), "true", false);
    }
}

