/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniparc.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.impl.RequestResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcField;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.DefaultUniParcRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.ResponseAdaptors;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.UniParcEntryAdaptor;
import uk.ac.ebi.uniprot.dataservice.document.uniparc.UniParcDocument;
import uk.ac.ebi.uniprot.dataservice.query.Query;

class UniParcServiceImpl
implements UniParcService {
    public static final String NAME_REMOTE_SERVER_URL = "UNIPARC_REMOTE_SERVER_URL";
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final RequestResponseFactory factory;
    private final BasicService<Response<UniParcDocument>> service;

    @Inject
    public UniParcServiceImpl(RequestResponseFactory factory, @Named(value="UNIPARC_REMOTE_SERVER_URL") String serverURL, HttpRequestConfig serverConfig) {
        this.factory = factory;
        this.service = factory.createServiceForResponseType(serverURL, serverConfig, UniParcDocument.class);
    }

    @Override
    public QueryResult<UniParcEntry> getEntries(Query query) throws ServiceException {
        DefaultUniParcRequest request = new DefaultUniParcRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setResultCardinality(100);
        Response<UniParcDocument> execute = this.service.execute(request);
        return this.factory.createQueryResult(this.service, request, execute, UniParcEntryAdaptor.getInstance());
    }

    @Override
    public QueryResult<UniParcEntry> getEntries(Query query, int offset, int pagesize) throws ServiceException {
        if (pagesize == -1) {
            return this.getEntries(query);
        }
        DefaultUniParcRequest request = new DefaultUniParcRequest(this.factory.createRequest());
        request.setQuery(query);
        if (pagesize < 10000) {
            request.setCursorMark(null);
        }
        request.setResultCardinality(pagesize);
        request.setResultOffset(offset);
        request.setSort(UniParcField.Search.upi, false);
        Response<UniParcDocument> execute = this.service.execute(request);
        return this.factory.createQueryResult(this.service, request, execute, UniParcEntryAdaptor.getInstance());
    }

    @Override
    public UniParcEntry getEntry(String id) throws ServiceException {
        Query query = UniParcQueryBuilder.id(id);
        DefaultUniParcRequest request = new DefaultUniParcRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setResultCardinality(1);
        Response<UniParcDocument> execute = this.service.execute(request);
        List<UniParcDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniParcDocument uniParcDocument = results.get(0);
            return UniParcEntryAdaptor.getInstance().adapt(uniParcDocument);
        }
        return null;
    }

    @Override
    public UniParcEntry getEntryFromUniProtAccession(String accession) throws ServiceException {
        Query query = UniParcQueryBuilder.uniProtAccession(accession);
        DefaultUniParcRequest request = new DefaultUniParcRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setResultCardinality(1);
        Response<UniParcDocument> execute = this.service.execute(request);
        List<UniParcDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniParcDocument uniParcDocument = results.get(0);
            return UniParcEntryAdaptor.getInstance().adapt(uniParcDocument);
        }
        return null;
    }

    @Override
    public QueryResult<UniParcComponent<Sequence>> getSequences(Query query) throws ServiceException {
        DefaultUniParcRequest request = new DefaultUniParcRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setFields(UniParcField.Return.upi, UniParcField.Return.avro_binary);
        request.setResultCardinality(100);
        Response<UniParcDocument> execute = this.service.execute(request);
        return this.factory.createQueryResult(this.service, request, execute, ResponseAdaptors.SEQUENCE_RESPONSE_ADAPTOR);
    }

    @Override
    public boolean isStarted() {
        return this.service.isStarted();
    }

    @Override
    public void start() {
        this.service.start();
    }

    @Override
    public void stop() {
        this.service.stop();
    }
}

