/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniparc.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.UniParcEntryStoreResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.UniParcServiceImpl;
import uk.ac.ebi.uniprot.dataservice.document.uniparc.UniParcDocument;
import uk.ac.ebi.uniprot.dataservice.voldemort.VoldemortClient;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniparc.VoldemortInMemoryUniparcEntryStore;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniparc.VoldemortRemoteUniparcEntryStore;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroUniParc;

public class UniParcGuiceModule
extends AbstractModule {
    public static final String UNIPARC_SERVICE_URL = "uniparcServiceURL";
    private final String serviceUrl;
    private final String voldemortUrl;
    private final String voldemortStoreName;
    private final String avroBinaryDocumentFieldName;
    private final String documentId;

    public UniParcGuiceModule(Properties configProperties) {
        this.serviceUrl = configProperties.getProperty(UNIPARC_SERVICE_URL);
        this.voldemortUrl = configProperties.getProperty("uniparcVoldemortUrl");
        this.voldemortStoreName = configProperties.getProperty("uniparcVoldemortStoreName");
        this.avroBinaryDocumentFieldName = configProperties.getProperty("uniparcAvroFieldName");
        this.documentId = configProperties.getProperty("uniparcDocumentId");
    }

    protected void configure() {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"UNIPARC_REMOTE_SERVER_URL")).to(this.serviceUrl);
        this.bind(UniParcService.class).to(UniParcServiceImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniparcAvroFieldName")).to(this.avroBinaryDocumentFieldName);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniparcDocumentId")).to(this.documentId);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniparcVoldemortUrl")).to(this.voldemortUrl);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"uniparcVoldemortStoreName")).to(this.voldemortStoreName);
        if (this.voldemortUrl.equals("inMemory")) {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<AvroUniParc>>(){}).toInstance((Object)VoldemortInMemoryUniparcEntryStore.getInstance((String)this.voldemortStoreName));
        } else {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<AvroUniParc>>(){}).toInstance((Object)new VoldemortRemoteUniparcEntryStore(this.voldemortStoreName, this.voldemortUrl));
        }
        this.getResponseFactoryMapBinder().addBinding(UniParcDocument.class).to(UniParcEntryStoreResponseFactory.class);
    }

    private MapBinder<Class<?>, ResponseFactory> getResponseFactoryMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<ResponseFactory>(){});
    }
}

