/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniparc;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseType;
import uk.ac.ebi.kraken.util.AccessionResolver;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcField;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.QueryFactory;
import uk.ac.ebi.uniprot.dataservice.query.impl.Accessor;

public class UniParcQueryBuilder {
    public static QueryFactory factory() {
        return Accessor.getDefault().getQueryFactoryInstance();
    }

    public static Query id(String uniParcID) {
        if (Strings.isNullOrEmpty((String)uniParcID)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (AccessionResolver.isUniparcAccession(uniParcID)) {
            return UniParcQueryBuilder.query(UniParcField.Search.upi, uniParcID.toUpperCase());
        }
        return UniParcQueryBuilder.factory().createEmptyQuery();
    }

    public static Query accession(String accession) {
        if (Strings.isNullOrEmpty((String)accession)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.accession, accession);
    }

    public static Query uniProtAccession(String accession) {
        if (Strings.isNullOrEmpty((String)accession)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        if (AccessionResolver.isUniprotAccession(accession)) {
            return UniParcQueryBuilder.query(UniParcField.Search.uniprot_accession, accession);
        }
        return UniParcQueryBuilder.factory().createEmptyQuery();
    }

    public static Query database(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.database_type, type);
    }

    public static Query database(DatabaseType type) {
        return UniParcQueryBuilder.query(UniParcField.Search.database_type, type.toString());
    }

    public static Query gene(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.gene, name);
    }

    public static Query proteinName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.protein, name);
    }

    public static Query taxonId(int taxId) {
        return UniParcQueryBuilder.query(UniParcField.Search.taxId, String.valueOf(taxId));
    }

    public static Query organismName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.organism_name, name);
    }

    public static Query checksum(String checksum) {
        if (Strings.isNullOrEmpty((String)checksum)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.query(UniParcField.Search.sequence_checksum, checksum);
    }

    public static Query seqLength(int length) {
        return UniParcQueryBuilder.query(UniParcField.Search.length, "" + length);
    }

    public static Query seqLengthRange(int start, int end) {
        return UniParcQueryBuilder.factory().createRangeQuery(UniParcField.Search.length.name(), "" + start, true, "" + end, true);
    }

    public static Query query(UniParcField.Search field, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("query term cannot be empty.");
        }
        return UniParcQueryBuilder.factory().createPhraseQuery(field.name(), value, false);
    }

    public static Query ipr(String ipr) {
        return UniParcQueryBuilder.query(UniParcField.Search.ipr, ipr);
    }

    public static Query signatureId(String signatureId) {
        return UniParcQueryBuilder.query(UniParcField.Search.signature_id, signatureId);
    }

    public static Query signatureType(String signatureType) {
        return UniParcQueryBuilder.query(UniParcField.Search.signature_type, signatureType);
    }

    public static Query upid(String upid) {
        return UniParcQueryBuilder.query(UniParcField.Search.upid, upid);
    }

    public static Query and(Query ... subQueries) {
        return UniParcQueryBuilder.factory().and(subQueries);
    }

    public static Query or(Query ... subQueries) {
        return UniParcQueryBuilder.factory().or(subQueries);
    }

    public static Query not(UniParcField.Search field, String value) {
        return UniParcQueryBuilder.factory().createPhraseQuery(field.name(), value, true);
    }
}

