/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniRefRetrievalExamples;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniRefSearchExamples;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.CheckStatus;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerMain;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.UtilException;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;

public class UniRefServiceChecker
implements ServiceChecker<UniRefService> {
    private final UniRefService service;
    private final String accession = "P10415";

    public UniRefServiceChecker(UniRefService service) {
        this.service = service;
    }

    @Override
    public CheckStatus runCheck(boolean fullCheck) {
        return fullCheck ? this.fullCheck() : this.briefCheck();
    }

    @Override
    public CheckStatus fullCheck() {
        List<UtilException.Consumer_WithExceptions> checks = Arrays.asList(UniRefRetrievalExamples::retrieveTaxAndMember, UniRefRetrievalExamples::retrieveEntryById, UniRefRetrievalExamples::retrieveEntryByUniProtAccession, UniRefRetrievalExamples::retrieveEntryByUniParcId, UniRefRetrievalExamples::retrieveRepresentativeByTaxIdWithinOneDatabase, UniRefRetrievalExamples::retrieveEntryNameByDatabaseType, UniRefSearchExamples::searchForUniRefClusterIdentifier, UniRefSearchExamples::searchForUniRefClusterName, UniRefSearchExamples::searchForUniRefDatabaseType, UniRefSearchExamples::searchForUniRefRepresentiveId, UniRefSearchExamples::searchForRepresentativeAccession, UniRefSearchExamples::searchForRepresentativeUpi, UniRefSearchExamples::searchForRepresentativeProteionName, UniRefSearchExamples::searchForMemberProteionName, UniRefSearchExamples::searchForMemberOrganismName, UniRefSearchExamples::searchForMemberTaxIdWithinOneDatabase);
        List<CheckStatus> collect = checks.stream().map(c -> this.checkService(c)).collect(Collectors.toList());
        return CheckStatus.result(collect);
    }

    @Override
    public CheckStatus briefCheck() {
        List<UtilException.Consumer_WithExceptions> checks = Arrays.asList(UniRefRetrievalExamples::retrieveEntryById);
        List collect = checks.stream().map(c -> this.checkService(c)).collect(Collectors.toList());
        return (CheckStatus)collect.get(0);
    }

    @Override
    public ServiceCheckerMain.ServiceEnum getServiceEnum() {
        return ServiceCheckerMain.ServiceEnum.uniref;
    }

    @Override
    public UniRefService getService() {
        return this.service;
    }
}

