/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniProtRetrievalExamples;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniProtSearchExamples;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.CheckStatus;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerMain;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.UtilException;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class UniProtServiceChecker
implements ServiceChecker<UniProtService> {
    private final UniProtService service;
    private final String accession = "P10415";

    public UniProtServiceChecker(UniProtService service) {
        this.service = service;
    }

    @Override
    public CheckStatus runCheck(boolean fullCheck) {
        return fullCheck ? this.fullCheck() : this.briefCheck();
    }

    @Override
    public CheckStatus fullCheck() {
        CheckStatus checkStatus = this.briefCheck();
        Query query = UniProtQueryBuilder.accession("P10415");
        List<UtilException.BiConsumer_WithExceptions> checks = Arrays.asList(UniProtRetrievalExamples::accessXrefsOnly, UniProtRetrievalExamples::accessGenesOnly, UniProtRetrievalExamples::accessECsOnly, UniProtRetrievalExamples::accessProteinNamesOnly, UniProtRetrievalExamples::accessFeaturesOnly, UniProtRetrievalExamples::accessCommentsOnly, UniProtRetrievalExamples::accessResults);
        List<UtilException.Consumer_WithExceptions> checks2 = Arrays.asList(UniProtSearchExamples::searchByProteinID, UniProtSearchExamples::searchByPrimaryAccession, UniProtSearchExamples::searchBySecondaryAccession, UniProtSearchExamples::searchForSwissProt, UniProtSearchExamples::searchForEntriesCreatedBetween, UniProtSearchExamples::searchForEntriesCreatedAfter, UniProtSearchExamples::searchForEntriesWithPublicationDatesBetween, UniProtSearchExamples::searchForPublicationPubmedId, UniProtSearchExamples::searchForPublicationTitle, UniProtSearchExamples::searchForComments, UniProtSearchExamples::searchForIsoformComments, UniProtSearchExamples::searchForFeatures, UniProtSearchExamples::searchForGoTerm, UniProtSearchExamples::searchForDatabaseCrossReference, UniProtSearchExamples::searchForProteinExistence, UniProtSearchExamples::searchForEntriesWithProteinName, UniProtSearchExamples::searchForEntriesWithEcNumber, UniProtSearchExamples::searchForFragmentedProteinEntries, UniProtSearchExamples::searchForEntriesWithGeneName, UniProtSearchExamples::searchForEntriesWithOrganismName, UniProtSearchExamples::searchForEntriesWithOrganismTaxonomy, UniProtSearchExamples::searchForEntriesWithLineage, UniProtSearchExamples::searchForEntriesWithTaxonIdInLineage, UniProtSearchExamples::searchForEntriesWithKeywords, UniProtSearchExamples::searchForEntriesWithOrganelle, UniProtSearchExamples::orExample, UniProtSearchExamples::andExample);
        List<CheckStatus> collect = checks.stream().map(c -> this.checkService(query, c)).collect(Collectors.toList());
        List collect2 = checks2.stream().map(c -> this.checkService(c)).collect(Collectors.toList());
        collect.addAll(collect2);
        collect.add(checkStatus);
        return CheckStatus.result(collect);
    }

    @Override
    public CheckStatus briefCheck() {
        List<UtilException.BiConsumer_WithExceptions> checks = Arrays.asList(UniProtRetrievalExamples::accessSingleFullUniProtEntry);
        List collect = checks.stream().map(c -> this.checkService("P10415", c)).collect(Collectors.toList());
        return (CheckStatus)collect.get(0);
    }

    @Override
    public ServiceCheckerMain.ServiceEnum getServiceEnum() {
        return ServiceCheckerMain.ServiceEnum.uniprot;
    }

    @Override
    public UniProtService getService() {
        return this.service;
    }
}

