/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniParcRetrievalExamples;
import uk.ac.ebi.uniprot.dataservice.client.examples.UniParcSearchExamples;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.CheckStatus;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerMain;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.UtilException;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;

public class UniParcServiceChecker
implements ServiceChecker<UniParcService> {
    private final UniParcService service;
    private final String accession = "P10415";

    public UniParcServiceChecker(UniParcService service) {
        this.service = service;
    }

    @Override
    public CheckStatus fullCheck() {
        List<UtilException.Consumer_WithExceptions> checks = Arrays.asList(UniParcRetrievalExamples::retrieveEntryUsingEntryIdentifier, UniParcRetrievalExamples::retrieveEntryUsingUniProtAccession, UniParcRetrievalExamples::retrieveEntriesUsingQuery, UniParcRetrievalExamples::retrieveUniParcSequencesUsingQuery, UniParcSearchExamples::searchForUniParcIdentifier, UniParcSearchExamples::searchForDatabaseType, UniParcSearchExamples::searchForDatabaseAccession, UniParcSearchExamples::searchForUniProtDatabaseAccession, UniParcSearchExamples::searchForGeneName, UniParcSearchExamples::searchForTaxonomicIdentifier, UniParcSearchExamples::searchForOrganismName);
        List<CheckStatus> collect = checks.stream().map(c -> this.checkService(c)).collect(Collectors.toList());
        return CheckStatus.result(collect);
    }

    @Override
    public CheckStatus briefCheck() {
        List<UtilException.Consumer_WithExceptions> checks = Arrays.asList(UniParcRetrievalExamples::retrieveEntryUsingEntryIdentifier);
        List collect = checks.stream().map(c -> this.checkService(c)).collect(Collectors.toList());
        return (CheckStatus)collect.get(0);
    }

    @Override
    public ServiceCheckerMain.ServiceEnum getServiceEnum() {
        return ServiceCheckerMain.ServiceEnum.uniparc;
    }

    @Override
    public UniParcService getService() {
        return this.service;
    }
}

