/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class UtilException {
    public static <T, R> BiConsumer<T, R> rethrowBiConsumer(BiConsumer_WithExceptions<T, R> consumer) {
        return (t, r) -> {
            try {
                consumer.accept(t, r);
            }
            catch (Exception exception) {
                UtilException.throwAsUnchecked(exception);
            }
        };
    }

    public static <T> Consumer<T> rethrowConsumer(Consumer_WithExceptions<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                UtilException.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R> Function<T, R> rethrowFunction(Function_WithExceptions<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                UtilException.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> Supplier<T> rethrowSupplier(Supplier_WithExceptions<T> function) {
        return () -> {
            try {
                return function.get();
            }
            catch (Exception exception) {
                UtilException.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    public static void uncheck(Runnable_WithExceptions t) {
        try {
            t.accept();
        }
        catch (Exception exception) {
            UtilException.throwAsUnchecked(exception);
        }
    }

    public static <R> R uncheck(Supplier_WithExceptions<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            UtilException.throwAsUnchecked(exception);
            return null;
        }
    }

    public static <T, R> R uncheck(Function_WithExceptions<T, R> function, T t) {
        try {
            return function.apply(t);
        }
        catch (Exception exception) {
            UtilException.throwAsUnchecked(exception);
            return null;
        }
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface BiConsumer<T, R> {
        public void accept(T var1, R var2);
    }

    @FunctionalInterface
    public static interface BiConsumer_WithExceptions<T, R> {
        public void accept(T var1, R var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Runnable_WithExceptions {
        public void accept() throws Exception;
    }

    @FunctionalInterface
    public static interface Supplier_WithExceptions<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Consumer_WithExceptions<T> {
        public void accept(T var1) throws Exception;
    }
}

