/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.performance;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class UniProtPerformanceIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniProtPerformanceIndicator.class);
    private static final Query query = UniProtQueryBuilder.swissprot();
    private static final boolean useSolrAndBdb = true;
    private static final int MAX_ENTRIES = 500000;
    private static final int LOG_INTERVAL_SECONDS = 10;

    public static void main(String[] args) {
        UniProtPerformanceIndicator.runSolrAndBdbQuery(query);
    }

    private static void runSolrAndBdbQuery(Query query) {
        Function resultsFunction = service -> {
            try {
                LOGGER.info(">>>>>> Query: {} -------------", (Object)query.getQueryString());
                return service.getEntries(query);
            }
            catch (ServiceException e) {
                LOGGER.error("Problem: ", (Throwable)e);
                return null;
            }
        };
        Function<UniProtEntry, String> showSimpleResult = entry -> entry.getPrimaryUniProtAccession().getValue();
        UniProtPerformanceIndicator.showPerformance("Retrieving BDB entries", resultsFunction, showSimpleResult);
    }

    private static void runOnlySolrQuery(Query query) {
        Function resultsFunction = service -> {
            try {
                LOGGER.info(">>>>>> Query: {} -------------", (Object)query.getQueryString());
                return service.getResults(query, UniProtData.ComponentType.values());
            }
            catch (ServiceException e) {
                LOGGER.error("Problem: ", (Throwable)e);
                return null;
            }
        };
        Function<UniProtData, String> showSimpleResult = entry -> entry.getAccession().getValue();
        UniProtPerformanceIndicator.showPerformance("Retrieving all components from Solr documents", resultsFunction, showSimpleResult);
    }

    protected static <E> void showPerformance(String header, Function<UniProtService, QueryResult<E>> resultFunction, Function<E, String> accessResultElementFunction) {
        LOGGER.info(">>> Experiment: {} -------------", (Object)header);
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniProtService uniProtService = serviceFactoryInstance.getUniProtQueryService();
        uniProtService.start();
        QueryResult<E> entryResult = resultFunction.apply(uniProtService);
        LOGGER.info("Running searchQuery");
        AtomicInteger count = new AtomicInteger();
        AtomicInteger delta = new AtomicInteger();
        long[] checkPoint = new long[]{System.nanoTime()};
        while (entryResult.hasNext()) {
            Object entry = entryResult.next();
            if (count.get() >= 500000) break;
            long timeGone = TimeUnit.SECONDS.convert(System.nanoTime() - checkPoint[0], TimeUnit.NANOSECONDS);
            if (timeGone > 10L && timeGone != 0L) {
                double rate = (long)delta.get() / timeGone;
                LOGGER.info("total={}, delta={}, rate={} entries/s (latest accession: {})", new Object[]{count.get(), delta.get(), Math.round(rate), accessResultElementFunction.apply(entry)});
                delta.set(0);
                checkPoint[0] = System.nanoTime();
            }
            delta.getAndIncrement();
            count.getAndIncrement();
        }
        uniProtService.stop();
        LOGGER.info("Service now stopped.");
    }
}

