/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.info.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObjectReader;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.RawInfoObjectImpl;

public class UrlRawInfoObjectReader
implements RawInfoObjectReader {
    public static final String INFO_REST_URL = "InfoServiceRestUrl";
    private final String serviceurl;
    private static final Logger logger = LoggerFactory.getLogger(UrlRawInfoObjectReader.class);

    @Inject
    public UrlRawInfoObjectReader(@Named(value="InfoServiceRestUrl") String serviceurl) {
        this.serviceurl = serviceurl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Optional<RawInfoObject> read() {
        HttpURLConnection urlConnection = null;
        try {
            Optional<RawInfoObject> optional;
            Object object;
            InputStream inputStream;
            block25: {
                block26: {
                    URL url = new URL(this.serviceurl + "?raw=true");
                    urlConnection = (HttpURLConnection)url.openConnection();
                    inputStream = urlConnection.getInputStream();
                    object = null;
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    RawInfoObjectImpl rawInfoObject = new RawInfoObjectImpl(properties);
                    optional = Optional.of(rawInfoObject);
                    if (inputStream == null) break block25;
                    if (object == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block25;
                }
                inputStream.close();
            }
            return optional;
            catch (Throwable throwable) {
                Optional<RawInfoObject> optional2;
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (inputStream != null) {
                                if (object != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Error while reading from input", (Throwable)e);
                        object = Optional.empty();
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        return object;
                    }
                }
                catch (MalformedURLException e) {
                    logger.warn("Error while parse url", (Throwable)e);
                    optional2 = Optional.empty();
                    return optional2;
                }
                catch (IOException e) {
                    logger.warn("Error while open url connection", (Throwable)e);
                    optional2 = Optional.empty();
                    return optional2;
                }
                finally {
                }
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }
}

