/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.uniprot.dataservice.client.QueryResultPage;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;

class DefaultQueryResultPageImpl<T, S>
implements QueryResultPage<T> {
    private final Request q;
    private final Response<S> response;
    protected final ResponseAdaptor<T, S> adaptor;
    protected final BasicService<? extends Response<S>> service;

    public DefaultQueryResultPageImpl(BasicService<? extends Response<S>> service, Request q, Response<S> response, ResponseAdaptor<T, S> adaptor) {
        this.q = q;
        this.response = response;
        this.adaptor = adaptor;
        this.service = service;
    }

    @Override
    public QueryResultPage<T> fetchNextPage() throws ServiceException {
        String requestCursormark = this.q.getCursorMark();
        String cursorMark = this.response.getCursorMark();
        if (requestCursormark != null && requestCursormark.equals(cursorMark)) {
            return null;
        }
        Request request = cursorMark == null ? this.q.pageRequest(this.q.getResultOffset() + (long)this.q.getResultCardinality()) : this.q.pageRequest(cursorMark);
        Response<S> execute = this.service.execute(request);
        return new DefaultQueryResultPageImpl<T, S>(this.service, request, execute, this.adaptor);
    }

    @Override
    public long pageOffset() {
        return this.response.getResultSetStart();
    }

    @Override
    public int pageSize() {
        return this.response.getResultPageSize();
    }

    @Override
    public long getTotalRecords() {
        return this.response.getHitCount();
    }

    @Override
    public List<T> getResults() {
        List<S> results = this.response.getResults();
        ArrayList<T> ts = new ArrayList<T>(results.size());
        for (S s : results) {
            ts.add(this.adaptor.adapt(s));
        }
        return ts;
    }

    @Override
    public T getResult(int index) {
        List<S> results = this.response.getResults();
        return this.adaptor.adapt(results.get(index));
    }

    @Override
    public String getNextPageCursorMark() {
        return this.response.getCursorMark();
    }
}

