/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.QueryResultPage;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultQueryResultPageImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class DefaultQueryResultImpl<T, S>
implements QueryResult<T> {
    private final BasicService<? extends Response<S>> service;
    protected final Request request;
    protected final Response<? extends S> response;
    private final ResponseAdaptor<T, S> adaptor;
    private QueryResultPage<T> currentPage;
    private int currentPageIndex = 0;
    private static final int MAX_FETCH_SIZE = 1000000;
    private int fetchCount = 0;
    private static final Logger logger = LoggerFactory.getLogger(DefaultQueryResultImpl.class);
    private final int maxFetchSize;

    public DefaultQueryResultImpl(BasicService<? extends Response<S>> service, Request request, Response<S> response, ResponseAdaptor<T, S> adaptor, int maxFetchSize) {
        this.service = service;
        this.request = request;
        this.response = response;
        this.adaptor = adaptor;
        this.currentPageIndex = 0;
        this.fetchCount = 0;
        this.currentPage = this.createPage(response);
        this.maxFetchSize = maxFetchSize <= 0 || maxFetchSize > 1000000 ? 1000000 : maxFetchSize;
    }

    public DefaultQueryResultImpl(BasicService<? extends Response<S>> service, Request request, Response<S> response, ResponseAdaptor<T, S> adaptor) {
        this(service, request, response, adaptor, 1000000);
    }

    private QueryResultPage<T> createPage(Response<S> response) {
        return new DefaultQueryResultPageImpl<T, S>(this.service, this.request, response, this.adaptor);
    }

    @Override
    public Query getQuery() {
        return this.request.getQuery();
    }

    @Override
    public long getNumberOfHits() {
        return this.response.getHitCount();
    }

    @Override
    public boolean hasNext() {
        if (this.fetchCount > this.maxFetchSize) {
            logger.info("Number of fetched result is larger than the maximum fetched size");
            return false;
        }
        return (long)this.fetchCount < this.response.getHitCount() && this.currentPage != null && this.currentPageIndex < this.currentPage.pageSize();
    }

    private T getNext() {
        if (this.fetchCount > this.maxFetchSize) {
            logger.info("Number of fetched result is larger than the maximum fetched size");
            return null;
        }
        T result = this.currentPage.getResult(this.currentPageIndex);
        ++this.fetchCount;
        ++this.currentPageIndex;
        if (this.currentPageIndex == this.currentPage.pageSize() && (long)this.fetchCount < this.response.getHitCount()) {
            try {
                this.currentPage = this.currentPage.fetchNextPage();
            }
            catch (ServiceException e) {
                this.currentPage = null;
                logger.warn("Error while fetching the next page", (Throwable)e);
            }
            this.currentPageIndex = 0;
        }
        return result;
    }

    @Override
    public T next() {
        T result = this.getNext();
        return result;
    }

    @Override
    public void remove() {
    }

    @Override
    public QueryResultPage<T> getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public T getFirstResult() {
        List<T> results = this.currentPage.getResults();
        if (results != null && !results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }
}

