/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.Alignment;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AlignmentImpl;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastSummaryImpl;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.ConverterUtils;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.SummaryConverter;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.TAlignment;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.TAlignments;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THit;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.TMatchSeq;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.TQuerySeq;

@Singleton
class SummaryConverterImpl
implements SummaryConverter<THit, BlastSummary> {
    SummaryConverterImpl() {
    }

    @Override
    public BlastSummary convert(THit rawHitResult) {
        if (rawHitResult == null) {
            throw new IllegalArgumentException("Can not convert null raw result");
        }
        BlastSummaryImpl hit = new BlastSummaryImpl();
        hit.hitNumber = ConverterUtils.zeroIfNull(rawHitResult.getNumber());
        hit.entryId = ConverterUtils.emptyIfNull(rawHitResult.getId());
        hit.database = ConverterUtils.emptyIfNull(rawHitResult.getDatabase());
        hit.description = ConverterUtils.emptyIfNull(rawHitResult.getDescription());
        hit.sequenceLength = ConverterUtils.zeroIfNull(rawHitResult.getLength());
        hit.alignments = this.convertRawAlignmentToAlignments(rawHitResult.getAlignments());
        return hit;
    }

    private List<Alignment> convertRawAlignmentToAlignments(TAlignments rawAlignments) {
        List<Alignment> alignments;
        if (rawAlignments != null) {
            alignments = new ArrayList<Alignment>(rawAlignments.getTotal());
            for (TAlignment rawAlignment : rawAlignments.getAlignment()) {
                AlignmentImpl alignment = new AlignmentImpl();
                alignment.score = ConverterUtils.zeroIfNull(rawAlignment.getScore());
                alignment.bitScore = ConverterUtils.zeroIfNull(rawAlignment.getBits());
                alignment.swScore = ConverterUtils.zeroIfNull(rawAlignment.getSmithWatermanScore());
                alignment.zScore = ConverterUtils.zeroIfNull(rawAlignment.getZScore());
                alignment.expectation = ConverterUtils.zeroIfNull(rawAlignment.getExpectation());
                alignment.positives = ConverterUtils.zeroIfNull(rawAlignment.getPositives());
                alignment.gaps = ConverterUtils.zeroIfNull(rawAlignment.getGaps());
                alignment.ungaps = ConverterUtils.zeroIfNull(rawAlignment.getUngapped());
                alignment.identity = ConverterUtils.zeroIfNull(rawAlignment.getIdentity());
                alignment.probability = ConverterUtils.zeroIfNull(rawAlignment.getProbability());
                alignment.overlap = ConverterUtils.emptyIfNull(rawAlignment.getOverlap());
                alignment.strand = ConverterUtils.emptyIfNull(rawAlignment.getStrand());
                alignment.pattern = ConverterUtils.emptyIfNull(rawAlignment.getPattern());
                TQuerySeq rawQuerySeq = rawAlignment.getQuerySeq();
                if (rawQuerySeq != null) {
                    this.populateQuerySeq(alignment, rawQuerySeq.getValue(), rawQuerySeq.getStart(), rawQuerySeq.getEnd());
                } else {
                    this.populateQuerySeq(alignment, null, null, null);
                }
                TMatchSeq rawMatchSeq = rawAlignment.getMatchSeq();
                if (rawMatchSeq != null) {
                    this.populateMatchSeq(alignment, rawMatchSeq.getValue(), rawMatchSeq.getStart(), rawMatchSeq.getEnd());
                } else {
                    this.populateMatchSeq(alignment, null, null, null);
                }
                alignments.add(alignment);
            }
        } else {
            alignments = Collections.emptyList();
        }
        return alignments;
    }

    private void populateQuerySeq(AlignmentImpl alignment, String sequence, Integer start, Integer end) {
        alignment.querySeq = ConverterUtils.emptyIfNull(sequence);
        alignment.querySeqStart = ConverterUtils.zeroIfNull(start);
        alignment.querySeqEnd = ConverterUtils.zeroIfNull(end);
    }

    private void populateMatchSeq(AlignmentImpl alignment, String sequence, Integer start, Integer end) {
        alignment.matchSeq = ConverterUtils.emptyIfNull(sequence);
        alignment.matchSeqStart = ConverterUtils.zeroIfNull(start);
        alignment.matchSeqEnd = ConverterUtils.zeroIfNull(end);
    }
}

