/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.util;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PropertyType;
import uk.ac.ebi.kraken.xml.xdb.DatabaseDef;
import uk.ac.ebi.kraken.xml.xdb.DbField;
import uk.ac.ebi.kraken.xml.xdb.UniProtXRefDBDefCache;

public class XMLDBXrefHelper {
    private static ObjectFactory objectFactory = new ObjectFactory();

    private static String getValue(String xmltagName, List<PropertyType> propertyList) {
        if (xmltagName != null && !xmltagName.isEmpty()) {
            for (PropertyType xmlProperty : propertyList) {
                if (!xmlProperty.getType().equalsIgnoreCase(xmltagName)) continue;
                return xmlProperty.getValue();
            }
        }
        return "-";
    }

    public static void createDBRefFromXML(DatabaseCrossReference db, List<PropertyType> propertyList) {
        DbField field;
        DefaultXRefFactory fact = DefaultXRefFactory.getInstance();
        DatabaseDef dbdef = UniProtXRefDBDefCache.getInstance().getXRefDBDef(db.getDatabase());
        List<DbField> fields = dbdef.getFields();
        String xmltagName = "Description";
        if (fields.size() > 1) {
            field = fields.get(1);
            xmltagName = XMLDBXrefHelper.getXmlTagName(field);
        }
        String value = XMLDBXrefHelper.getValue(xmltagName, propertyList);
        db.setDescription(fact.buildXDBAttribute(value));
        for (int i = 2; i < fields.size(); ++i) {
            field = fields.get(i);
            xmltagName = field.getXmlTag();
            value = XMLDBXrefHelper.getValue(xmltagName, propertyList);
            if (i == 2) {
                db.setThird(fact.buildXDBAttribute(value));
                continue;
            }
            if (i != 3) continue;
            db.setFourth(fact.buildXDBAttribute(value));
        }
    }

    public static void createXMLFromDBRef(DbReferenceType xmlReference, DatabaseCrossReference dbxref) {
        DbField field;
        DatabaseType dbdef = dbxref.getDatabase();
        String value = dbxref.getDescription().getValue();
        List<DbField> fields = UniProtXRefDBDefCache.getInstance().getXRefDBDef(dbdef).getFields();
        String xmltagName = "Description";
        if (fields.size() > 1) {
            field = fields.get(1);
            xmltagName = XMLDBXrefHelper.getXmlTagName(field);
        }
        XMLDBXrefHelper.addProperty(xmltagName, value, xmlReference);
        for (int i = 2; i < fields.size(); ++i) {
            field = fields.get(i);
            xmltagName = field.getXmlTag();
            value = "-";
            if (i == 2) {
                value = dbxref.getThird().getValue();
            } else if (i == 3) {
                value = dbxref.getFourth().getValue();
            }
            XMLDBXrefHelper.addProperty(xmltagName, value, xmlReference);
        }
    }

    private static String getXmlTagName(DbField field) {
        String xmltagName = field.getXmlTag();
        return xmltagName == null ? field.getName() : xmltagName;
    }

    private static void addProperty(String propertyName, String value, DbReferenceType xmlReference) {
        if (!(propertyName == null || propertyName.isEmpty() || value.equals("") || value.equals("-"))) {
            PropertyType property = objectFactory.createPropertyType();
            property.setType(propertyName);
            property.setValue(value);
            xmlReference.getProperty().add(property);
        }
    }
}

