/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.organism;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class NcbiTaxonomyIdsUpdater
implements GenericUpdater<List<NcbiTaxonomyId>, OrganismType> {
    private final UniProtFactory uniProtFactory;
    private final EvidenceReferenceHandler evidencesHandler;
    private final ObjectFactory objectFactory;

    public NcbiTaxonomyIdsUpdater(UniProtFactory uniProtFactory, EvidenceReferenceHandler evidencesHandler, ObjectFactory objectFactory) {
        this.uniProtFactory = uniProtFactory;
        this.evidencesHandler = evidencesHandler;
        this.objectFactory = objectFactory;
    }

    @Override
    public void fromXmlBinding(List<NcbiTaxonomyId> ncbiTaxonomyIds, OrganismType xmlOrganism) {
        List<DbReferenceType> dbReferenceTypes = xmlOrganism.getDbReference();
        for (DbReferenceType xmlDBref : dbReferenceTypes) {
            NcbiTaxonomyId taxID = this.uniProtFactory.buildNcbiTaxonomyId(xmlDBref.getId());
            taxID.setEvidenceIds(this.evidencesHandler.parseEvidenceIDs(xmlOrganism.getEvidence()));
            ncbiTaxonomyIds.add(taxID);
        }
    }

    @Override
    public void toXmlBinding(OrganismType organismXML, List<NcbiTaxonomyId> taxonomyIds) {
        List<Integer> evs;
        DbReferenceType dbReferenceXML = this.objectFactory.createDbReferenceType();
        dbReferenceXML.setType("NCBI Taxonomy");
        dbReferenceXML.setId(taxonomyIds.get(0).getValue());
        if (!taxonomyIds.get(0).getEvidenceIds().isEmpty() && !(evs = this.evidencesHandler.writeEvidenceIDs(taxonomyIds.get(0).getEvidenceIds())).isEmpty()) {
            organismXML.getEvidence().addAll(evs);
        }
        organismXML.getDbReference().add(dbReferenceXML);
    }
}

