/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.organelle;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.GeneLocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.StatusType;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class OrganelleHandler
implements GenericHandler<List<Organelle>, List<GeneLocationType>> {
    private final EvidenceReferenceHandler referenceHandler;
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;

    public OrganelleHandler(UniProtFactory uniProtFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.uniProtFactory = uniProtFactory;
        this.objectFactory = objectFactory;
        this.referenceHandler = evidenceReferenceHandler;
    }

    @Override
    public List<Organelle> fromXmlBinding(List<GeneLocationType> listGeneLocationXML) {
        ArrayList<Organelle> organelles = new ArrayList<Organelle>();
        for (GeneLocationType geneLocationXML : listGeneLocationXML) {
            GeneEncodingType geneEncodingType = GeneEncodingType.typeOf(geneLocationXML.getType());
            if (geneLocationXML.getName() != null && !geneLocationXML.getName().isEmpty()) {
                String value = "";
                int count = 0;
                for (StatusType name : geneLocationXML.getName()) {
                    if (count == 1) {
                        value = value + " (";
                    }
                    value = value + name.getValue();
                    ++count;
                }
                if (count > 1) {
                    value = value + ")";
                }
                Organelle organelle = this.uniProtFactory.buildOrganelle(geneEncodingType);
                organelle.setValue(value);
                organelle.setEvidenceIds(this.parseEvidenceIDs(geneLocationXML.getEvidence()));
                organelles.add(organelle);
                continue;
            }
            Organelle organelle = this.uniProtFactory.buildOrganelle(geneEncodingType);
            organelle.setEvidenceIds(this.parseEvidenceIDs(geneLocationXML.getEvidence()));
            organelles.add(organelle);
        }
        return organelles;
    }

    @Override
    public List<GeneLocationType> toXmlBinding(List<Organelle> organelles) {
        ArrayList<GeneLocationType> listGeneLocationXML = new ArrayList<GeneLocationType>();
        for (Organelle organelle : organelles) {
            List<Integer> evs;
            GeneLocationType geneLocationXML = this.objectFactory.createGeneLocationType();
            geneLocationXML.setType(organelle.getType().getValue().toLowerCase());
            if (organelle.getType() == GeneEncodingType.PLASMID && organelle.hasValue() && !organelle.getValue().isEmpty()) {
                String value = organelle.getValue();
                if (value.endsWith(")") && value.indexOf(" (") != -1) {
                    int index = value.lastIndexOf(" (");
                    String first = value.substring(0, index);
                    String second = value.substring(index + 2, value.length() - 1);
                    StatusType statusType = this.objectFactory.createStatusType();
                    statusType.setValue(first);
                    geneLocationXML.getName().add(statusType);
                    StatusType statusType2 = this.objectFactory.createStatusType();
                    statusType2.setValue(second);
                    geneLocationXML.getName().add(statusType2);
                } else {
                    StatusType statusType = this.objectFactory.createStatusType();
                    statusType.setValue(organelle.getValue());
                    geneLocationXML.getName().add(statusType);
                }
            }
            if (!organelle.getEvidenceIds().isEmpty() && !(evs = this.referenceHandler.writeEvidenceIDs(organelle.getEvidenceIds())).isEmpty()) {
                geneLocationXML.getEvidence().addAll(evs);
            }
            listGeneLocationXML.add(geneLocationXML);
        }
        return listGeneLocationXML;
    }

    List<EvidenceId> parseEvidenceIDs(List<Integer> evidences) {
        ArrayList<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();
        if (evidences != null && !evidences.isEmpty()) {
            EvidenceFactory evidenceFactory = this.uniProtFactory.buildEvidenceFactory();
            for (Integer evidence : evidences) {
                evidenceIds.add(evidenceFactory.buildEvidenceId(this.referenceHandler.getEvidenceIdForIndex(evidence)));
            }
        }
        return evidenceIds;
    }
}

