/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantReport;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.uniprot.feature.AltSequenceHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureIdHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;

public class VariantHandlerStrategy
implements FeatureHandlerStrategy<VariantFeature> {
    private final LocationHandlerStrategy locationHandlerStrategy;
    private final FeatureIdHandlerStrategy featureIdHandlerStrategy;
    private final AltSequenceHandlerStrategy altSequenceHandlerStrategy;

    public VariantHandlerStrategy(LocationHandlerStrategy locationHandlerStrategy, FeatureIdHandlerStrategy featureIdHandlerStrategy, AltSequenceHandlerStrategy altSequenceHandlerStrategy) {
        this.locationHandlerStrategy = locationHandlerStrategy;
        this.featureIdHandlerStrategy = featureIdHandlerStrategy;
        this.altSequenceHandlerStrategy = altSequenceHandlerStrategy;
    }

    @Override
    public void featureFromXmlBinding(VariantFeature variantFeature, FeatureType xmlFeature) {
        this.variantFromXmlBinding(variantFeature, xmlFeature);
    }

    private void variantFromXmlBinding(VariantFeature variantFeature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureFromXmlBinding(variantFeature, xmlFeature);
        this.featureIdHandlerStrategy.featureFromXmlBinding(variantFeature, xmlFeature);
        this.altSequenceHandlerStrategy.featureFromXmlBinding(variantFeature, xmlFeature);
        String description = xmlFeature.getDescription();
        if (description != null) {
            this.convertToReport(variantFeature, description);
        }
    }

    @Override
    public void featureToXmlBinding(VariantFeature feature, FeatureType xmlFeature) {
        this.variantToXmlBinding(feature, xmlFeature);
    }

    private void variantToXmlBinding(VariantFeature variantFeature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureToXmlBinding(variantFeature, xmlFeature);
        this.featureIdHandlerStrategy.featureToXmlBinding(variantFeature, xmlFeature);
        this.altSequenceHandlerStrategy.featureToXmlBinding(variantFeature, xmlFeature);
        String description = this.fetchDecriptionFromReport(variantFeature);
        if (!Strings.isNullOrEmpty((String)description)) {
            xmlFeature.setDescription(description);
        }
    }

    private String fetchDecriptionFromReport(VariantFeature feature) {
        VariantReport report = feature.getVariantReport();
        if (report != null) {
            String val = report.getValue();
            if (val.length() > 0 && !(val = val.substring(0, 1).toUpperCase() + val.substring(1)).endsWith(".")) {
                val = val + ".";
            }
            return val;
        }
        return "";
    }

    private void convertToReport(VariantFeature feature, String value) {
        if (value != null && value.length() > 0 && (value = value.substring(0, 1).toLowerCase() + value.substring(1)).endsWith(".")) {
            value = value.substring(0, value.length() - 1).trim();
        }
        VariantReport aVariantReport = DefaultFeatureFactory.getInstance().buildVariantReport();
        aVariantReport.setValue(value);
        feature.setVariantReport(aVariantReport);
    }
}

