/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.parser.FeatureHelper;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.AltSequenceHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;

public class ConflictHandlerStrategy
implements FeatureHandlerStrategy<ConflictFeature> {
    private final CitationReferenceHandler citationReferenceHandler;
    private final AltSequenceHandlerStrategy altSequenceHandlerStrategy;
    private final LocationHandlerStrategy locationHandlerStrategy;

    public ConflictHandlerStrategy(LocationHandlerStrategy locationHandlerStrategy, AltSequenceHandlerStrategy altSequenceHandlerStrategy, CitationReferenceHandler citationReferenceHandler) {
        this.locationHandlerStrategy = locationHandlerStrategy;
        this.altSequenceHandlerStrategy = altSequenceHandlerStrategy;
        this.citationReferenceHandler = citationReferenceHandler;
    }

    @Override
    public void featureFromXmlBinding(ConflictFeature feature, FeatureType xmlFeature) {
        this.conflictFromXmlBinding(feature, xmlFeature);
    }

    private void conflictFromXmlBinding(ConflictFeature feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureFromXmlBinding(feature, xmlFeature);
        this.altSequenceHandlerStrategy.featureFromXmlBinding(feature, xmlFeature);
        String description = xmlFeature.getDescription();
        if (description != null) {
            if ((description = description.substring(0, 1).toLowerCase() + description.substring(1)).endsWith(".")) {
                description = description.substring(0, description.length() - 1).trim();
            }
            description = "(" + description + ")";
            FeatureHelper.consumeConflictReport(feature, description);
        }
    }

    @Override
    public void featureToXmlBinding(ConflictFeature feature, FeatureType xmlFeature) {
        this.conflictToXmlBinding(feature, xmlFeature);
    }

    private void conflictToXmlBinding(ConflictFeature feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureToXmlBinding(feature, xmlFeature);
        this.altSequenceHandlerStrategy.featureToXmlBinding(feature, xmlFeature);
        StringBuilder sb = new StringBuilder();
        List<Integer> references = FeatureHelper.getReferencesForConflictFeature(feature);
        for (Integer reference : references) {
            if (!this.citationReferenceHandler.isHoldingReference(reference)) continue;
            sb.append(reference);
            sb.append(" ");
        }
        xmlFeature.setRef(sb.toString().trim());
        StringBuilder buffer = new StringBuilder();
        buffer.append(FeatureHelper.getStringConflictReports(feature));
        String description = buffer.toString();
        description = description.substring(0, 1).toUpperCase() + description.substring(1);
        if (!description.endsWith(".")) {
            description = description + ".";
        }
        xmlFeature.setDescription(description);
    }
}

