/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.feature.DescriptionHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureIdHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.StatusHandlerStrategy;

public class CommonFeatureHandlerStrategy<P extends Feature>
implements FeatureHandlerStrategy<P> {
    private final FeatureFactory featureFactory;
    private final ObjectFactory xmlUniprotFactory;
    private final LocationHandlerStrategy locationHandlerStrategy;
    private final StatusHandlerStrategy statusHandlerStrategy;
    private final DescriptionHandlerStrategy descriptionHandlerStrategy;
    private final FeatureIdHandlerStrategy featureIdHandlerStrategy;

    public CommonFeatureHandlerStrategy() {
        this.featureFactory = DefaultUniProtFactory.getFeatureFactory();
        this.xmlUniprotFactory = new ObjectFactory();
        this.locationHandlerStrategy = new LocationHandlerStrategy(this.featureFactory, this.xmlUniprotFactory);
        this.statusHandlerStrategy = new StatusHandlerStrategy();
        this.descriptionHandlerStrategy = new DescriptionHandlerStrategy();
        this.featureIdHandlerStrategy = new FeatureIdHandlerStrategy();
    }

    CommonFeatureHandlerStrategy(FeatureFactory featureFactory, ObjectFactory xmlUniprotFactory, LocationHandlerStrategy locationHandlerStrategy, StatusHandlerStrategy statusHandlerStrategy, DescriptionHandlerStrategy descriptionHandlerStrategy, FeatureIdHandlerStrategy featureIdHandlerStrategy) {
        this.featureFactory = featureFactory;
        this.xmlUniprotFactory = xmlUniprotFactory;
        this.locationHandlerStrategy = locationHandlerStrategy;
        this.statusHandlerStrategy = statusHandlerStrategy;
        this.descriptionHandlerStrategy = descriptionHandlerStrategy;
        this.featureIdHandlerStrategy = featureIdHandlerStrategy;
    }

    @Override
    public void featureFromXmlBinding(P feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureFromXmlBinding((Feature)feature, xmlFeature);
        this.statusHandlerStrategy.featureFromXmlBinding((Feature)feature, xmlFeature);
        if (feature instanceof HasFeatureDescription) {
            this.descriptionHandlerStrategy.featureFromXmlBinding((HasFeatureDescription)feature, xmlFeature);
        }
        if (feature instanceof HasFeatureId) {
            this.featureIdHandlerStrategy.featureFromXmlBinding((HasFeatureId)feature, xmlFeature);
        }
    }

    @Override
    public void featureToXmlBinding(P feature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureToXmlBinding((Feature)feature, xmlFeature);
        this.statusHandlerStrategy.featureToXmlBinding((Feature)feature, xmlFeature);
        if (feature instanceof HasFeatureDescription) {
            this.descriptionHandlerStrategy.featureToXmlBinding((HasFeatureDescription)feature, xmlFeature);
        }
        if (feature instanceof HasFeatureId) {
            if (!((HasFeatureId)feature).getFeatureId().getValue().isEmpty()) {
                xmlFeature.setId(((HasFeatureId)feature).getFeatureId().getValue());
            }
            this.featureIdHandlerStrategy.featureToXmlBinding((HasFeatureId)feature, xmlFeature);
        }
    }
}

