/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasAlternativeSequence;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.FeatureHelper;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;

public class AltSequenceHandlerStrategy
implements FeatureHandlerStrategy<HasAlternativeSequence> {
    private FeatureFactory featureFactory;
    private String sequence;

    public AltSequenceHandlerStrategy() {
        this(DefaultUniProtFactory.getFeatureFactory());
    }

    public AltSequenceHandlerStrategy(FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public void featureFromXmlBinding(HasAlternativeSequence feature, FeatureType xmlFeature) {
        if (xmlFeature.getOriginal() != null) {
            feature.getOriginalSequence().setValue(xmlFeature.getOriginal());
            List<String> variations = xmlFeature.getVariation();
            for (String variant : variations) {
                FeatureSequence ss = this.featureFactory.buildFeatureSequence(variant);
                feature.getAlternativeSequences().add(ss);
            }
        }
        this.subSequenceFromXmlBinding(feature);
    }

    @Override
    public void featureToXmlBinding(HasAlternativeSequence feature, FeatureType xmlFeature) {
        String original = feature.getOriginalSequence().getValue();
        List<FeatureSequence> variations = feature.getAlternativeSequences();
        if (original != null && !original.isEmpty() && !variations.isEmpty()) {
            xmlFeature.setOriginal(original);
            for (FeatureSequence sequence : variations) {
                xmlFeature.getVariation().add(sequence.getValue());
            }
        }
    }

    private void subSequenceFromXmlBinding(HasAlternativeSequence feature) {
        if (this.sequence != null && !this.sequence.isEmpty() && feature.getOriginalSequence().getValue().isEmpty() && !this.sequence.isEmpty()) {
            FeatureHelper.extractSequenceLocation(this.sequence, feature);
        }
    }
}

