/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericSectionHandler;

public class IncludesSectionHandler
extends GenericSectionHandler<ProteinType.Domain> {
    public IncludesSectionHandler(ObjectFactory objectFactory, UniProtFactory factory, Map<NameType, GenericNameHandler> nameHandlerMap) {
        super(objectFactory, factory, nameHandlerMap);
    }

    @Override
    public ProteinType.Domain toXmlSection(Section section) {
        ProteinType proteinType = this.populateProteinType(section);
        return this.convertToDomain(proteinType);
    }

    private ProteinType.Domain convertToDomain(ProteinType proteinType) {
        if (proteinType != null) {
            List<EvidencedStringType> innNameList;
            List<EvidencedStringType> cdAntigeneNameList;
            List<ProteinType.SubmittedName> subNameList;
            ProteinType.Domain domain = this.objectFactory.createProteinTypeDomain();
            domain.setRecommendedName(proteinType.getRecommendedName());
            domain.setAllergenName(proteinType.getAllergenName());
            domain.setBiotechName(proteinType.getBiotechName());
            List<ProteinType.AlternativeName> altNameList = proteinType.getAlternativeName();
            if (!altNameList.isEmpty()) {
                domain.getAlternativeName().addAll(altNameList);
            }
            if (!(subNameList = proteinType.getSubmittedName()).isEmpty()) {
                domain.getSubmittedName().addAll(subNameList);
            }
            if (!(cdAntigeneNameList = proteinType.getCdAntigenName()).isEmpty()) {
                domain.getCdAntigenName().addAll(cdAntigeneNameList);
            }
            if (!(innNameList = proteinType.getInnName()).isEmpty()) {
                domain.getInnName().addAll(innNameList);
            }
            return domain;
        }
        return null;
    }

    @Override
    public Section fromXmlSection(ProteinType.Domain domain) {
        if (domain != null) {
            return this.populateSection(this.convertToProteinType(domain));
        }
        return null;
    }

    private ProteinType convertToProteinType(ProteinType.Domain domain) {
        if (domain != null) {
            List<EvidencedStringType> innNameList;
            List<EvidencedStringType> cdAntigeneNameList;
            List<ProteinType.SubmittedName> subNameList;
            ProteinType proteinType = this.objectFactory.createProteinType();
            proteinType.setRecommendedName(domain.getRecommendedName());
            proteinType.setAllergenName(domain.getAllergenName());
            proteinType.setBiotechName(domain.getBiotechName());
            List<ProteinType.AlternativeName> altNameList = domain.getAlternativeName();
            if (!altNameList.isEmpty()) {
                proteinType.getAlternativeName().addAll(altNameList);
            }
            if (!(subNameList = domain.getSubmittedName()).isEmpty()) {
                proteinType.getSubmittedName().addAll(subNameList);
            }
            if (!(cdAntigeneNameList = domain.getCdAntigenName()).isEmpty()) {
                proteinType.getCdAntigenName().addAll(cdAntigeneNameList);
            }
            if (!(innNameList = domain.getInnName()).isEmpty()) {
                proteinType.getInnName().addAll(innNameList);
            }
            return proteinType;
        }
        return null;
    }
}

