/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.AlternativeNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericXmlName;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class FieldAlternativeNameHandler
extends GenericNameHandler<ProteinType, Section> {
    private final GenericNameHandler<ProteinType.AlternativeName, Name> alternativeNameNameHandler;

    public FieldAlternativeNameHandler(ObjectFactory objectFactory, UniProtFactory factory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecNumberHandler) {
        super(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler);
        this.alternativeNameNameHandler = new AlternativeNameHandler(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler);
    }

    @Override
    public ProteinType toXmlName(Section section) {
        if (section != null) {
            boolean touched = false;
            ProteinType proteinType = this.objectFactory.createProteinType();
            for (Name name : section.getNames()) {
                List<EvidencedStringType> xmlInnList;
                List<EvidencedStringType> xmlAntigenList;
                EvidencedStringType xmlBiotechName;
                GenericXmlName genericName;
                EvidencedStringType xmlAllergenName;
                if (name.getNameType() != NameType.ALTNAME) continue;
                ProteinType.AlternativeName alternativeName = this.alternativeNameNameHandler.toXmlName(name);
                if (alternativeName != null) {
                    proteinType.getAlternativeName().add(alternativeName);
                    touched = true;
                }
                if ((xmlAllergenName = (genericName = this.populateXmlName(name)).getAllergenName()) != null) {
                    proteinType.setAllergenName(xmlAllergenName);
                    touched = true;
                }
                if ((xmlBiotechName = genericName.getBiotechName()) != null) {
                    proteinType.setBiotechName(xmlBiotechName);
                    touched = true;
                }
                if ((xmlAntigenList = genericName.getCdAntigenName()) != null) {
                    proteinType.getCdAntigenName().addAll(xmlAntigenList);
                    touched = true;
                }
                if ((xmlInnList = genericName.getInnName()) == null) continue;
                proteinType.getInnName().addAll(xmlInnList);
                touched = true;
            }
            return touched ? proteinType : null;
        }
        return null;
    }

    @Override
    public Section fromXmlName(ProteinType altXmlName) {
        if (altXmlName != null) {
            Name altFieldName1;
            Section section = this.factory.buildSection();
            boolean touched = false;
            for (ProteinType.AlternativeName alternativeName : altXmlName.getAlternativeName()) {
                Name altName = this.alternativeNameNameHandler.fromXmlName(alternativeName);
                if (altName == null) continue;
                section.getNames().add(altName);
                touched = true;
            }
            Name altFieldName = this.populateName(this.convertAlternativeToGenericName(altXmlName));
            if (altFieldName != null) {
                altFieldName.setNameType(NameType.ALTNAME);
                section.getNames().add(altFieldName);
                touched = true;
            }
            if ((altFieldName1 = this.populateName(this.convertAlternativeToGenericName1(altXmlName))) != null) {
                altFieldName1.setNameType(NameType.ALTNAME);
                section.getNames().add(altFieldName1);
                touched = true;
            }
            List<GenericXmlName> nameList = this.convertAlternativeToGenericName2(altXmlName);
            for (GenericXmlName genericXmlName : nameList) {
                Name altFieldName2 = this.populateName(genericXmlName);
                if (altFieldName2 == null) continue;
                altFieldName2.setNameType(NameType.ALTNAME);
                section.getNames().add(altFieldName2);
                touched = true;
            }
            if (touched) {
                return section;
            }
        }
        return null;
    }

    private GenericXmlName convertAlternativeToGenericName(ProteinType altXmlName) {
        if (altXmlName != null) {
            GenericXmlName genericXmlName = new GenericXmlName();
            genericXmlName.setAllergenName(altXmlName.getAllergenName());
            genericXmlName.setBiotechName(altXmlName.getBiotechName());
            return genericXmlName;
        }
        return null;
    }

    private GenericXmlName convertAlternativeToGenericName1(ProteinType altXmlName) {
        if (altXmlName != null) {
            GenericXmlName genericXmlName = new GenericXmlName();
            if (!altXmlName.getCdAntigenName().isEmpty()) {
                genericXmlName.setCdAntigenName(altXmlName.getCdAntigenName());
            }
            return genericXmlName;
        }
        return null;
    }

    private List<GenericXmlName> convertAlternativeToGenericName2(ProteinType altXmlName) {
        ArrayList<GenericXmlName> genericXmlNames = new ArrayList<GenericXmlName>();
        if (altXmlName != null) {
            List<EvidencedStringType> innNames = altXmlName.getInnName();
            for (EvidencedStringType innName : innNames) {
                GenericXmlName genericXmlName = new GenericXmlName();
                genericXmlName.setInnName(Arrays.asList(innName));
                genericXmlNames.add(genericXmlName);
            }
            return genericXmlNames;
        }
        return null;
    }
}

