/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SubcellularLocationType;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentStatusHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocation;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocations;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SubcellularLocationTypeHandler
implements GenericHandler<SubcellularLocation, SubcellularLocationType> {
    private static final Pattern COMMA = Pattern.compile(",");
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final CommentStatusHandler commentStatusHandler;
    private final EvidenceReferenceHandler evReferenceHandler;
    private SubcellLocations subcellLocations;

    public SubcellularLocationTypeHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler, CommentStatusHandler commentStatusHandler, SubcellLocations subcellLocations) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evReferenceHandler = referenceHandler;
        this.commentStatusHandler = commentStatusHandler;
        this.subcellLocations = subcellLocations;
    }

    @Override
    public SubcellularLocation fromXmlBinding(SubcellularLocationType subLocationXML) {
        SubcellularLocation subcellularLocation = this.commentFactory.buildSubcellularLocation();
        if (subLocationXML != null) {
            List<EvidenceId> evidenceIds;
            String locationStr = this.getLocationValues(subLocationXML.getLocation());
            SubcellularLocationValue locationValue = this.commentFactory.buildSubcellularLocationValue();
            locationValue.setValue(locationStr);
            for (EvidencedStringType locationType : subLocationXML.getLocation()) {
                if (!locationType.getEvidence().isEmpty()) {
                    List<EvidenceId> evidenceIds2 = this.evReferenceHandler.parseEvidenceIDs(locationType.getEvidence());
                    for (EvidenceId evidenceId : evidenceIds2) {
                        if (evidenceId.getValue().trim().isEmpty()) continue;
                        locationValue.getEvidenceIds().add(evidenceId);
                    }
                }
                subcellularLocation.setLocation(locationValue);
            }
            if (!subLocationXML.getOrientation().isEmpty()) {
                String orientationStr = this.getLocationValues(subLocationXML.getOrientation());
                SubcellularLocationValue orientationL = this.commentFactory.buildSubcellularLocationValue();
                orientationL.setValue(orientationStr);
                for (EvidencedStringType orientation : subLocationXML.getOrientation()) {
                    if (!orientation.getEvidence().isEmpty()) {
                        evidenceIds = this.evReferenceHandler.parseEvidenceIDs(orientation.getEvidence());
                        for (EvidenceId evidenceId : evidenceIds) {
                            if (evidenceId.getValue().trim().isEmpty()) continue;
                            orientationL.getEvidenceIds().add(evidenceId);
                        }
                    }
                    subcellularLocation.setOrientation(orientationL);
                }
            }
            if (!subLocationXML.getTopology().isEmpty()) {
                String topologyStr = this.getLocationValues(subLocationXML.getTopology());
                SubcellularLocationValue topologyL = this.commentFactory.buildSubcellularLocationValue();
                topologyL.setValue(topologyStr);
                for (EvidencedStringType topology : subLocationXML.getTopology()) {
                    if (!topology.getEvidence().isEmpty()) {
                        evidenceIds = this.evReferenceHandler.parseEvidenceIDs(topology.getEvidence());
                        for (EvidenceId evidenceId : evidenceIds) {
                            if (evidenceId.getValue().trim().isEmpty()) continue;
                            topologyL.getEvidenceIds().add(evidenceId);
                        }
                    }
                    subcellularLocation.setTopology(topologyL);
                }
            }
            return subcellularLocation;
        }
        return null;
    }

    private String getLocationValues(List<EvidencedStringType> values) {
        Map<EvidencedStringType, String> map = this.transferCase(values);
        return values.stream().map(val -> (String)map.get(val)).collect(Collectors.joining(", "));
    }

    private Map<EvidencedStringType, String> transferCase(List<EvidencedStringType> values) {
        String subcellLine = values.stream().map(val -> val.getValue()).collect(Collectors.joining(", "));
        SubcellLocation location = this.subcellLocations.getLocation(subcellLine);
        HashMap<EvidencedStringType, String> map = new HashMap<EvidencedStringType, String>();
        for (int i = 0; i < values.size(); ++i) {
            EvidencedStringType est = values.get(i);
            if (location != null && est.getValue().equalsIgnoreCase(location.getLocation().get(i))) {
                map.put(est, location.getLocation().get(i));
                continue;
            }
            map.put(est, est.getValue());
        }
        return map;
    }

    @Override
    public SubcellularLocationType toXmlBinding(SubcellularLocation subcellularLocation) {
        SubcellularLocationType subcellularLocationType = this.objectFactory.createSubcellularLocationType();
        if (subcellularLocation != null) {
            String[] tops;
            String[] locations;
            for (String value : locations = COMMA.split(subcellularLocation.getLocation().getValue().trim())) {
                String aLocation = value.trim();
                if (aLocation.isEmpty()) continue;
                subcellularLocationType.getLocation().add(this.buildLocation(aLocation, subcellularLocation.getLocation()));
            }
            EvidencedStringType orientationType = this.buildLocation(subcellularLocation.getOrientation());
            if (orientationType != null) {
                subcellularLocationType.getOrientation().add(orientationType);
            }
            for (String value : tops = COMMA.split(subcellularLocation.getTopology().getValue().trim())) {
                String aTopology = value.trim();
                if (aTopology.isEmpty()) continue;
                subcellularLocationType.getTopology().add(this.buildLocation(aTopology, subcellularLocation.getTopology()));
            }
            return subcellularLocationType;
        }
        return null;
    }

    private EvidencedStringType buildLocation(String value, SubcellularLocationValue locationValue) {
        List<Integer> evs;
        EvidencedStringType typeLocation = this.objectFactory.createEvidencedStringType();
        typeLocation.setValue(StringUtils.capitalize((String)value));
        this.commentStatusHandler.setCommentStatusToXml(locationValue, typeLocation);
        List<EvidenceId> evidenceIds = locationValue.getEvidenceIds();
        if (evidenceIds != null && !evidenceIds.isEmpty() && !(evs = this.evReferenceHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
            typeLocation.getEvidence().addAll(evs);
        }
        return typeLocation;
    }

    private EvidencedStringType buildLocation(SubcellularLocationValue locationValue) {
        if (locationValue != null && !locationValue.getValue().isEmpty()) {
            List<Integer> evs;
            EvidencedStringType typeLocation = this.objectFactory.createEvidencedStringType();
            typeLocation.setValue(StringUtils.capitalize((String)locationValue.getValue()));
            this.commentStatusHandler.setCommentStatusToXml(locationValue, typeLocation);
            List<EvidenceId> evidenceIds = locationValue.getEvidenceIds();
            if (evidenceIds != null && !evidenceIds.isEmpty() && !(evs = this.evReferenceHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
                typeLocation.getEvidence().addAll(evs);
            }
            return typeLocation;
        }
        return null;
    }
}

