/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SubcellularLocationType;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentStatusHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocations;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SubcellularLocationHandler
implements GenericHandler<SubcellularLocationComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private CommentFactory commentFactory;
    private ObjectFactory objectFactory;
    private EvidenceReferenceHandler evidenceReferenceHandler;
    private CommentItemFactory itemFactory;
    private final EvidencedValueHandler evidencedValueHandler;
    private final GenericHandler<SubcellularLocation, SubcellularLocationType> subcellularLocationTypeHandler;

    public SubcellularLocationHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler, CommentStatusHandler commentStatusHandler, SubcellLocations subcellLocations) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
        this.itemFactory = new CommentItemFactory();
        this.itemFactory.setObjectFactory(objectFactory);
        this.itemFactory.setCommentFactory(commentFactory);
        this.itemFactory.setCommentStatusHandler(commentStatusHandler);
        this.itemFactory.setEvidenceReferenceHandler(this.evidenceReferenceHandler);
        this.itemFactory.setSubcellLocations(subcellLocations);
        this.subcellularLocationTypeHandler = this.itemFactory.buildSubcellularLocationTypeHandler();
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler, true);
    }

    @Override
    public SubcellularLocationComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        if (commentXML != null) {
            SubcellularLocationComment comment = (SubcellularLocationComment)this.commentFactory.buildComment(CommentType.SUBCELLULAR_LOCATION);
            if (commentXML.getMolecule() != null) {
                comment.setMolecule(commentXML.getMolecule().getValue());
            }
            for (SubcellularLocationType locationType : commentXML.getSubcellularLocation()) {
                comment.getSubcellularLocations().add(this.subcellularLocationTypeHandler.fromXmlBinding(locationType));
            }
            if (!commentXML.getText().isEmpty()) {
                SubcellularLocationNote subNote = this.commentFactory.buildSubcellularLocationNote();
                ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
                for (EvidencedStringType evStr : commentXML.getText()) {
                    evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
                }
                subNote.setTexts(evValues);
                comment.setSubcellularLocationNote(subNote);
            }
            if (!commentXML.getEvidence().isEmpty()) {
                comment.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(commentXML.getEvidence()));
            }
            return comment;
        }
        return null;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(SubcellularLocationComment comment) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        if (comment != null) {
            commentXML.setType(comment.getCommentType().toDisplayName().toLowerCase());
            if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
                MoleculeType mol = this.objectFactory.createMoleculeType();
                mol.setValue(comment.getMolecule());
                commentXML.setMolecule(mol);
            }
            for (SubcellularLocation subcellularLocation : comment.getSubcellularLocations()) {
                commentXML.getSubcellularLocation().add(this.subcellularLocationTypeHandler.toXmlBinding(subcellularLocation));
            }
            SubcellularLocationNote note = comment.getSubcellularLocationNote();
            if (note != null && !note.getTexts().isEmpty()) {
                for (EvidencedValue evValue : note.getTexts()) {
                    EvidencedStringType xmlText = this.evidencedValueHandler.toXmlBinding(evValue);
                    commentXML.getText().add(xmlText);
                }
            }
            if (!comment.getEvidenceIds().isEmpty()) {
                commentXML.getEvidence().addAll(this.evidenceReferenceHandler.writeEvidenceIDs(comment.getEvidenceIds()));
            }
            return commentXML;
        }
        return null;
    }
}

