/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.LocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class RnaEditingHandler
implements GenericHandler<RnaEditingComment, CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;
    private final EvidencedValueHandler evidencedValueHandler;
    private final GenericHandler<Position, LocationType> positionsHandler;

    public RnaEditingHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evRefHandler = evidenceReferenceHandler;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setEvidenceReferenceHandler(evidenceReferenceHandler);
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, evidenceReferenceHandler, true);
        this.positionsHandler = itemFactory.buildRnaEditingPositionsHandler();
    }

    @Override
    public RnaEditingComment fromXmlBinding(CommentType commentXML) {
        if (commentXML != null) {
            RnaEditingComment rnaEditingComment = this.commentFactory.buildRnaEditingComment();
            if (commentXML.getMolecule() != null) {
                rnaEditingComment.setMolecule(commentXML.getMolecule().getValue());
            }
            if (commentXML.getLocation() != null && !commentXML.getLocation().isEmpty()) {
                for (LocationType locationType : commentXML.getLocation()) {
                    rnaEditingComment.getPositionsWithEvidences().add(this.positionsHandler.fromXmlBinding(locationType));
                }
            }
            if (!commentXML.getText().isEmpty()) {
                RnaEditingNote rnaEditingNote = this.commentFactory.buildRnaEditingNote();
                ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
                for (EvidencedStringType evStr : commentXML.getText()) {
                    evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
                }
                rnaEditingNote.setTexts(evValues);
                rnaEditingComment.setRnaEditingNote(rnaEditingNote);
            }
            if (commentXML.getLocationType() != null) {
                rnaEditingComment.setLocationType(RnaEditingLocationType.getType(commentXML.getLocationType()));
            }
            if (!commentXML.getEvidence().isEmpty()) {
                rnaEditingComment.getEvidenceIds().addAll(this.evRefHandler.parseEvidenceIDs(commentXML.getEvidence()));
            }
            return rnaEditingComment;
        }
        return null;
    }

    @Override
    public CommentType toXmlBinding(RnaEditingComment rnaEditingComment) {
        if (rnaEditingComment != null) {
            List<Integer> evs;
            RnaEditingNote note;
            CommentType commentXML = this.objectFactory.createCommentType();
            if (!Strings.isNullOrEmpty((String)rnaEditingComment.getMolecule())) {
                MoleculeType mol = this.objectFactory.createMoleculeType();
                mol.setValue(rnaEditingComment.getMolecule());
                commentXML.setMolecule(mol);
            }
            if ((note = rnaEditingComment.getRnaEditingNote()) != null && !note.getTexts().isEmpty()) {
                for (EvidencedValue evValue : note.getTexts()) {
                    EvidencedStringType evidencedStringType = this.evidencedValueHandler.toXmlBinding(evValue);
                    commentXML.getText().add(evidencedStringType);
                }
            }
            if (rnaEditingComment.getLocationType() == RnaEditingLocationType.Not_applicable || rnaEditingComment.getLocationType() == RnaEditingLocationType.Undetermined) {
                commentXML.setLocationType(rnaEditingComment.getLocationType().name());
            } else {
                for (Position position : rnaEditingComment.getPositionsWithEvidences()) {
                    LocationType locationType = this.positionsHandler.toXmlBinding(position);
                    if (locationType == null) continue;
                    commentXML.getLocation().add(locationType);
                }
            }
            if (!rnaEditingComment.getEvidenceIds().isEmpty() && !(evs = this.evRefHandler.writeEvidenceIDs(rnaEditingComment.getEvidenceIds())).isEmpty()) {
                commentXML.getEvidence().addAll(evs);
            }
            return commentXML;
        }
        return null;
    }
}

