/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrieval;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseNotRecognizedException;

public class DiseaseHandler
implements GenericHandler<Disease, CommentType.Disease> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final DiseaseIdListRetrieval diseaseIdListRetrieval;

    public DiseaseHandler(CommentFactory commentFactory, ObjectFactory objectFactory, DiseaseIdListRetrieval diseaseIdListRetrieval) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.diseaseIdListRetrieval = diseaseIdListRetrieval;
    }

    @Override
    public Disease fromXmlBinding(CommentType.Disease xmlDisease) {
        if (xmlDisease == null) {
            return null;
        }
        Disease disease = this.commentFactory.buildDisease();
        disease.getAcronym().setValue(xmlDisease.getAcronym());
        disease.getDiseaseId().setValue(xmlDisease.getName());
        disease.getDescription().setValue(xmlDisease.getDescription());
        if (xmlDisease.getDbReference() != null) {
            disease.getReference().getDiseaseReferenceId().setValue(xmlDisease.getDbReference().getId());
            disease.getReference().setDiseaseReferenceType(DiseaseReferenceType.typeOf(xmlDisease.getDbReference().getType()));
        }
        return disease;
    }

    @Override
    public CommentType.Disease toXmlBinding(Disease disease) {
        if (disease == null) {
            return null;
        }
        CommentType.Disease xmlDisease = this.objectFactory.createCommentTypeDisease();
        xmlDisease.setAcronym(disease.getAcronym().getValue());
        xmlDisease.setName(disease.getDiseaseId().getValue());
        xmlDisease.setDescription(disease.getDescription().getValue());
        try {
            xmlDisease.setId(this.diseaseIdListRetrieval.retrieveIdForName(disease.getDiseaseId().getValue()));
        }
        catch (DiseaseNotRecognizedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DbReferenceType dbReferenceType = this.objectFactory.createDbReferenceType();
        dbReferenceType.setId(disease.getReference().getDiseaseReferenceId().getValue());
        dbReferenceType.setType(disease.getReference().getDiseaseReferenceType().name());
        xmlDisease.setDbReference(dbReferenceType);
        return xmlDisease;
    }
}

