/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.parser.CommentHelper;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.IsoformType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class AlternativeProductsIsoformHandler
implements GenericHandler<AlternativeProductsIsoform, IsoformType> {
    private static final Pattern SPACE = Pattern.compile(" ");
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public AlternativeProductsIsoformHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AlternativeProductsIsoform fromXmlBinding(IsoformType isoformXML) {
        Object isSynonym;
        AlternativeProductsIsoform isoform = this.commentFactory.buildAlternativeProductsIsoform();
        for (String string : isoformXML.getId()) {
            if (string == null || string.isEmpty()) continue;
            isoform.getIds().add(this.commentFactory.buildIsoformId(string));
        }
        boolean isName = true;
        for (IsoformType.Name name : isoformXML.getName()) {
            if (name == null || name.getValue().isEmpty()) continue;
            if (isName) {
                isoform.setName(this.commentFactory.buildIsoformName(name.getValue()));
                if (!name.getEvidence().isEmpty()) {
                    List<EvidenceId> evidenceIds = this.evidenceReferenceHandler.parseEvidenceIDs(name.getEvidence());
                    for (EvidenceId evidenceId : evidenceIds) {
                        if (evidenceId.getValue().trim().isEmpty()) continue;
                        isoform.getName().getEvidenceIds().add(evidenceId);
                    }
                }
                isName = false;
                continue;
            }
            isSynonym = this.commentFactory.buildIsoformSynonym(name.getValue());
            if (!name.getEvidence().isEmpty()) {
                List<EvidenceId> evidenceIds = this.evidenceReferenceHandler.parseEvidenceIDs(name.getEvidence());
                for (EvidenceId evidenceId2 : evidenceIds) {
                    if (evidenceId2.getValue().trim().isEmpty()) continue;
                    isSynonym.getEvidenceIds().add(evidenceId2);
                }
            }
            isoform.getSynonyms().add((IsoformSynonym)isSynonym);
        }
        IsoformType.Sequence sequence = isoformXML.getSequence();
        if (sequence.getRef() != null && !sequence.getRef().isEmpty()) {
            void var8_18;
            String[] isoformSequenceRefs = SPACE.split(sequence.getRef());
            isSynonym = isoformSequenceRefs;
            int n = ((String[])isSynonym).length;
            boolean bl = false;
            while (var8_18 < n) {
                String aRef = isSynonym[var8_18];
                isoform.getSequenceIds().add(this.commentFactory.buildIsoformSequenceId(aRef));
                ++var8_18;
            }
        }
        if (sequence.getType() != null) {
            isoform.setIsoformSequenceStatus(IsoformSequenceStatus.typeOf(sequence.getType()));
        }
        if (!isoformXML.getText().isEmpty()) {
            IsoformNote note = this.commentFactory.buildIsoformNote();
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            for (EvidencedStringType evidencedStringType : isoformXML.getText()) {
                evValues.add(this.evidencedValueHandler.fromXmlBinding(evidencedStringType));
            }
            note.setTexts(evValues);
            isoform.setNote(note);
        }
        return isoform;
    }

    @Override
    public IsoformType toXmlBinding(AlternativeProductsIsoform isoform) {
        IsoformType isoformType = this.objectFactory.createIsoformType();
        if (isoform != null) {
            IsoformType.Sequence sequenceXML;
            Object evidenceIds;
            if (isoform.getIds() != null && !isoform.getIds().isEmpty()) {
                for (IsoformId isoformId : isoform.getIds()) {
                    isoformType.getId().add(isoformId.getValue());
                }
            }
            if (isoform.hasName()) {
                IsoformType.Name nameXML = this.objectFactory.createIsoformTypeName();
                nameXML.setValue(isoform.getName().getValue());
                evidenceIds = this.evidenceReferenceHandler.writeEvidenceIDs(isoform.getName().getEvidenceIds());
                Iterator iterator = evidenceIds.iterator();
                while (iterator.hasNext()) {
                    Integer evidenceId = (Integer)iterator.next();
                    if (evidenceId == null || evidenceId == 0) continue;
                    nameXML.getEvidence().add(evidenceId);
                }
                isoformType.getName().add(nameXML);
            }
            if (isoform.getSynonyms() != null && !isoform.getSynonyms().isEmpty()) {
                List<IsoformSynonym> synonymList = isoform.getSynonyms();
                evidenceIds = synonymList.iterator();
                while (evidenceIds.hasNext()) {
                    IsoformSynonym isoformSynonym = (IsoformSynonym)evidenceIds.next();
                    if (isoformSynonym.getValue().isEmpty()) continue;
                    IsoformType.Name synonymXML = this.objectFactory.createIsoformTypeName();
                    synonymXML.setValue(isoformSynonym.getValue());
                    List<Integer> evidenceIds2 = this.evidenceReferenceHandler.writeEvidenceIDs(isoformSynonym.getEvidenceIds());
                    for (Integer evidenceId : evidenceIds2) {
                        if (evidenceId == null || evidenceId == 0) continue;
                        synonymXML.getEvidence().add(evidenceId);
                    }
                    isoformType.getName().add(synonymXML);
                }
            }
            if (isoform.hasNote()) {
                for (EvidencedValue evValue : isoform.getNote().getTexts()) {
                    EvidencedStringType evStr = this.evidencedValueHandler.toXmlBinding(evValue);
                    isoformType.getText().add(evStr);
                }
            }
            if (isoform.getSequenceIds().isEmpty()) {
                sequenceXML = this.objectFactory.createIsoformTypeSequence();
                sequenceXML.setType(isoform.getIsoformSequenceStatus().getValue());
                isoformType.setSequence(sequenceXML);
            } else {
                sequenceXML = this.objectFactory.createIsoformTypeSequence();
                sequenceXML.setType(isoform.getIsoformSequenceStatus().getValue());
                sequenceXML.setRef(CommentHelper.createSequenceIdString(isoform));
                isoformType.setSequence(sequenceXML);
            }
            return isoformType;
        }
        return null;
    }
}

